/*
 * Decompiled with CFR 0.152.
 */
package com.leo.powerpots.block.entity;

import com.leo.powerpots.block.PotTier;
import com.leo.powerpots.config.Config;
import com.leo.powerpots.energy.ModEnergyStorage;
import com.leo.powerpots.init.ModBlockEntities;
import java.util.List;
import java.util.Random;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PowerPotBE
extends BlockEntityBotanyPot {
    final Random rng = new Random();
    private long rngSeed;
    public ModEnergyStorage energyHandler;
    private LazyOptional<ModEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private PotTier tier;

    public PowerPotBE(BlockPos pPos, BlockState pBlockState, PotTier tier) {
        super((BlockEntityType)ModBlockEntities.POWER_POT_BE.get(), pPos, pBlockState);
        this.energyHandler = new ModEnergyStorage(tier.powerStorage(), tier.powerStorage(), 0, 0);
        this.customRefreshRandom();
        this.tier = tier;
    }

    public PowerPotBE(BlockPos pPos, BlockState pState) {
        this(pPos, pState, PotTier.ZERO);
    }

    public static void tickPot(Level level, BlockPos pos, BlockState state, PowerPotBE pot) {
        if (pot.m_58901_() || pot.m_58904_() == null) {
            return;
        }
        ((BotanyPotContainer)pot.getInventory()).update();
        Soil soil = pot.getSoil();
        Crop crop = pot.getCrop();
        if (soil != null) {
            soil.onTick(level, pos, (BlockEntityBotanyPot)pot);
        }
        if (crop != null) {
            crop.onTick(level, pos, (BlockEntityBotanyPot)pot);
        }
        if (pot.isHopper()) {
            if (pot.exportDelay > 0) {
                --pot.exportDelay;
            }
            if (pot.harvestDelay > 0) {
                --pot.harvestDelay;
            }
            if (crop != null && pot.harvestDelay < 1 && pot.isCropHarvestable()) {
                if (pot.attemptAutoHarvest()) {
                    pot.resetGrowth();
                }
                pot.harvestDelay = 50;
            }
            if (pot.exportDelay < 1) {
                pot.attemptExport();
                pot.exportDelay = 10;
            }
        }
        if (soil != null && crop != null && pot.areGrowthConditionsMet()) {
            if (!pot.doneGrowing) {
                boolean finishedGrowing;
                pot.growthTime += pot.tier.speedModifier();
                pot.energyHandler.removeEnergy(pot.tier.powerEachTick());
                soil.onGrowthTick(level, pos, (BlockEntityBotanyPot)pot, crop);
                crop.onGrowthTick(level, pos, (BlockEntityBotanyPot)pot, soil);
                pot.prevComparatorLevel = pot.comparatorLevel;
                pot.comparatorLevel = Mth.m_14143_((float)(15.0f * ((float)pot.growthTime / (float)((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime())));
                boolean bl = finishedGrowing = pot.growthTime >= ((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
                if (pot.doneGrowing != finishedGrowing) {
                    pot.doneGrowing = finishedGrowing;
                    pot.markDirty();
                }
            }
        } else if (pot.growthTime != -1 || pot.doneGrowing || pot.comparatorLevel != 0) {
            pot.resetGrowth();
        }
        if (pot.comparatorLevel != pot.prevComparatorLevel) {
            pot.prevComparatorLevel = pot.comparatorLevel;
            pot.f_58857_.m_46717_(pot.f_58858_, pot.m_58900_().m_60734_());
        }
    }

    public void customRefreshRandom() {
        this.rngSeed = Constants.RANDOM.nextLong();
        this.rng.setSeed(this.rngSeed);
    }

    public boolean attemptAutoHarvest() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && this.getCrop() != null) {
            ContainerInventoryAccess inventory = new ContainerInventoryAccess((Container)((BotanyPotContainer)this.getInventory()));
            this.rng.setSeed(this.rngSeed);
            List drops = BotanyPotHelper.generateDrop((Random)this.rng, (Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockEntityBotanyPot)this, (Crop)this.getCrop());
            if (drops.isEmpty()) {
                return true;
            }
            boolean didCollect = false;
            for (ItemStack drop : drops) {
                if (drop.m_41619_()) continue;
                drop.m_41764_(drop.m_41613_() * this.tier.itemAmountMultiplier());
                int originalSize = drop.m_41613_();
                for (int slot : BotanyPotContainer.STORAGE_SLOT) {
                    if (drop.m_41619_()) break;
                    drop = inventory.insert(slot, drop, Direction.UP, true, true);
                }
                if (drop.m_41613_() == originalSize) continue;
                didCollect = true;
            }
            return didCollect;
        }
        return false;
    }

    private void attemptExport() {
        if (this.m_58904_() == null || this.m_58904_().f_46443_) {
            return;
        }
        IInventoryAccess exportTo = Services.INVENTORY_HELPER.getInventory(this.m_58904_(), this.m_58899_().m_7495_(), Direction.UP);
        if (exportTo == null) {
            return;
        }
        block0: for (int potSlotId : BotanyPotContainer.STORAGE_SLOT) {
            ItemStack potStack = ((BotanyPotContainer)this.getInventory()).m_8020_(potSlotId);
            if (potStack.m_41619_()) continue;
            for (int exportSlotId : exportTo.getAvailableSlots()) {
                if (exportTo.insert(exportSlotId, potStack, Direction.UP, false).m_41613_() == potStack.m_41613_()) continue;
                ((BotanyPotContainer)this.getInventory()).m_6836_(potSlotId, exportTo.insert(exportSlotId, potStack, Direction.UP, true));
                continue block0;
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean areGrowthConditionsMet() {
        return super.areGrowthConditionsMet() && this.energyHandler.getEnergyStored() >= this.tier.powerEachTick();
    }

    public void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("energy", this.energyHandler.serializeNBT());
        pTag.m_128405_("potTier", this.tier.index());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        this.energyHandler.deserializeNBT(pTag.m_128423_("energy"));
        int index = pTag.m_128451_("potTier");
        this.tier = Config.INSTANCE.TIERS.get(index - 1);
        this.energyHandler = new ModEnergyStorage(this.tier.powerStorage(), this.tier.powerStorage(), 0, 0);
        super.m_142466_(pTag);
    }
}

