/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.thermo;

import dev.architectury.fluid.FluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.thermo.ThermoBlock;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.Util;

public class ThermoTile
extends AbstractEnergyProvider<ThermoBlock>
implements IInventoryHolder,
ITankHolder {
    public long generating;

    public ThermoTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.THERMO_GEN.get(), pos, state, variant);
        this.tank.setCapacity(FluidStack.bucketAmount() * 4L).validate(stack -> PowahAPI.getCoolant(stack.getFluid()) != 0).setChange(() -> this.sync(10));
        this.inv.add(1);
    }

    public ThermoTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag nbt) {
        super.readSync(nbt);
        this.generating = nbt.m_128454_("generating");
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt) {
        nbt.m_128356_("generating", this.generating);
        return super.writeSync(nbt);
    }

    @Override
    protected int postTick(Level world) {
        boolean flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        boolean i = false;
        if (!this.isRemote() && this.checkRedstone() && !this.tank.isEmpty()) {
            FluidStack fluid = this.tank.getFluid();
            int fluidCooling = PowahAPI.getCoolant(fluid.getFluid());
            if (fluidCooling != 0) {
                BlockPos heatPos = this.f_58858_.m_7495_();
                BlockState state = world.m_8055_(heatPos);
                Block block = state.m_60734_();
                int heat = PowahAPI.getHeatSource(block);
                if (!this.energy.isFull() && heat != 0) {
                    LiquidBlock fluidBlock;
                    if (block instanceof LiquidBlock && !(fluidBlock = (LiquidBlock)block).m_5888_(state).m_76170_()) {
                        int level = (Integer)state.m_61143_((Property)LiquidBlock.f_54688_);
                        heat = (int)((float)heat / ((float)level + 1.0f));
                    }
                    double heatRatio = (double)heat / 1000.0;
                    double coolingRatio = Math.max(1.0, (1.0 + (double)Math.abs(fluidCooling)) / 2.0);
                    this.generating = (int)(heatRatio * coolingRatio * (double)this.getGeneration());
                    this.energy.produce(this.generating);
                    if (world.m_46467_() % 40L == 0L) {
                        this.tank.drain(Util.millibucketAmount(), false);
                    }
                } else {
                    this.generating = 0L;
                }
            } else {
                this.generating = 0L;
            }
        }
        return flag || this.generating > 0L ? 5 : -1;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean keepFluid() {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

