/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.OptionalIntDataSlot;

public class BaseMenu<T extends BaseBlockEntity>
extends AbstractContainerMenu {
    public final T blockEntity;
    public final Inventory inventory;
    public final BaseItemHandler<?> itemHandler;
    protected int dragCount = 0;
    protected List<Slot> dragSlots = new ArrayList<Slot>();

    public BaseMenu(MenuType<?> menuType, int windowId, Inventory inventory, T blockEntity) {
        super(menuType, windowId);
        this.blockEntity = blockEntity;
        this.inventory = inventory;
        this.itemHandler = blockEntity != null ? ((BaseBlockEntity)((Object)blockEntity)).getItemHandler() : new BaseItemHandler<Object>(null, 0);
        this.m_38884_(this.itemHandler);
    }

    public int getPlayerInvX() {
        return 8;
    }

    public int getPlayerInvY() {
        return 84;
    }

    protected void setupPlayerInventory() {
        int i;
        int xOffset = this.getPlayerInvX();
        int yOffset = this.getPlayerInvY();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected void m_38884_(ContainerData array) {
        for (int i = 0; i < array.m_6499_(); ++i) {
            this.m_38895_(OptionalIntDataSlot.of(array, i));
        }
    }

    public int getSizeInventory() {
        return this.itemHandler.getSlots();
    }

    public boolean supportsShiftClick(Player player, int slotIndex) {
        return true;
    }

    public boolean performMerge(Player player, int slotIndex, ItemStack stack) {
        int invBase = this.getSizeInventory();
        int invFull = this.f_38839_.size();
        if (slotIndex < invBase) {
            return this.m_38903_(stack, invBase, invFull, true);
        }
        return this.m_38903_(stack, 0, invBase, false);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        if (!this.supportsShiftClick(player, slotIndex)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            stack = stackInSlot.m_41777_();
            if (!this.performMerge(player, slotIndex, stackInSlot)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stackInSlot, stack);
            if (stackInSlot.m_41613_() <= 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_5852_(stackInSlot);
            }
            if (stackInSlot.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return stack;
    }

    protected boolean m_38903_(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = !ascending ? slotMin : slotMax - 1;
        int n = iterOrder = !ascending ? 1 : -1;
        if (stack.m_41753_()) {
            while (stack.m_41613_() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.f_38839_.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.m_7993_();
                if (!existingStack.m_41619_() && slot.m_5857_(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.m_41741_(), slot.m_6641_()), stack.m_41613_()))) && ItemStack.m_150942_((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.m_41613_() + stack.m_41613_();
                    if (existingSize <= maxStack) {
                        stack.m_41764_(0);
                        existingStack.m_41764_(existingSize);
                        slot.m_5852_(existingStack);
                        successful = true;
                    } else if (existingStack.m_41613_() < maxStack) {
                        stack.m_41774_(maxStack - existingStack.m_41613_());
                        existingStack.m_41764_(maxStack);
                        slot.m_5852_(existingStack);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (stack.m_41613_() > 0) {
            int n2 = i = !ascending ? slotMin : slotMax - 1;
            while (stack.m_41613_() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.f_38839_.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.m_7993_();
                if (existingStack.m_41619_() && slot.m_5857_(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.m_41741_(), slot.m_6641_()), stack.m_41613_())))) {
                    existingStack = stack.m_41620_(rmv);
                    slot.m_5852_(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public void m_150399_(int slotId, int clickSubtype, ClickType clickType, Player player) {
        Object toPut2;
        if (clickType == ClickType.QUICK_CRAFT) {
            if (clickSubtype == 1 && slotId >= 0) {
                ++this.dragCount;
                Object object = this.f_38839_.get(slotId);
                if (object instanceof FalseCopySlot) {
                    FalseCopySlot slot = (FalseCopySlot)((Object)object);
                    this.dragSlots.add((Slot)slot);
                    return;
                }
            } else if (clickSubtype == 2 && !this.dragSlots.isEmpty()) {
                ItemStack toPut2 = this.m_142621_().m_41777_();
                toPut2.m_41764_(toPut2.m_41613_() / this.dragCount);
                for (Slot slot : this.dragSlots) {
                    slot.m_5852_(toPut2.m_41777_());
                }
                this.dragCount = 0;
                this.dragSlots.clear();
            }
        } else if (clickType != ClickType.CLONE && slotId >= 0 && (toPut2 = this.f_38839_.get(slotId)) instanceof FalseCopySlot) {
            FalseCopySlot slot = (FalseCopySlot)((Object)toPut2);
            if (clickType == ClickType.QUICK_MOVE) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                toPut2 = this.m_142621_().m_41777_();
                ItemStack stack = slot.m_7993_().m_41777_();
                if (clickSubtype == 0) {
                    slot.m_5852_((ItemStack)toPut2);
                } else if (clickSubtype == 1) {
                    if (stack.m_41619_()) {
                        if (!toPut2.m_41619_()) {
                            toPut2.m_41764_(1);
                        }
                        slot.m_5852_((ItemStack)toPut2);
                    } else if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)toPut2) && stack.m_41613_() < stack.m_41741_()) {
                        stack.m_41769_(1);
                        slot.m_5852_(stack);
                    } else {
                        stack.m_41774_(1);
                        slot.m_5852_(stack);
                    }
                }
            }
            return;
        }
        super.m_150399_(slotId, clickSubtype, clickType, player);
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity != null) {
            return Container.m_272074_(this.blockEntity, (Player)player);
        }
        return true;
    }
}

