/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IProxyMarkerItem;
import thelm.packagedauto.block.entity.CraftingProxyBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;

public class CraftingProxyItemHandler
extends BaseItemHandler<CraftingProxyBlockEntity> {
    public CraftingProxyItemHandler(CraftingProxyBlockEntity blockEntity) {
        super(blockEntity, 1);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.loadMarker();
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        IProxyMarkerItem marker;
        Item item = stack.m_41720_();
        return item instanceof IProxyMarkerItem && (marker = (IProxyMarkerItem)item).getDirectionalGlobalPos(stack) != null;
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.loadMarker();
    }

    public void loadMarker() {
        ItemStack stack = this.getStackInSlot(0);
        Item item = stack.m_41720_();
        if (item instanceof IProxyMarkerItem) {
            IProxyMarkerItem marker = (IProxyMarkerItem)item;
            DirectionalGlobalPos pos = marker.getDirectionalGlobalPos(stack);
            if (pos == null) {
                ((CraftingProxyBlockEntity)this.blockEntity).target = null;
            } else if (((CraftingProxyBlockEntity)this.blockEntity).m_58904_() != null && !((CraftingProxyBlockEntity)this.blockEntity).m_58904_().m_46472_().equals(pos.dimension())) {
                ((CraftingProxyBlockEntity)this.blockEntity).target = null;
            } else {
                BlockPos dirVec = pos.blockPos().m_121996_((Vec3i)((CraftingProxyBlockEntity)this.blockEntity).m_58899_());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.m_123341_()), Math.abs(dirVec.m_123342_()), Math.abs(dirVec.m_123343_())});
                if (dist <= CraftingProxyBlockEntity.range) {
                    ((CraftingProxyBlockEntity)this.blockEntity).target = pos;
                }
            }
        } else {
            ((CraftingProxyBlockEntity)this.blockEntity).target = null;
        }
    }
}

