/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;
import thelm.packagedauto.integration.jei.RecipeSlotsViewWrapper;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.SetRecipePacket;

public class EncoderTransferHandler
implements IUniversalRecipeTransferHandler<EncoderMenu> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public EncoderTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<EncoderMenu> getContainerClass() {
        return EncoderMenu.class;
    }

    public Optional<MenuType<EncoderMenu>> getMenuType() {
        return Optional.empty();
    }

    public IRecipeTransferError transferRecipe(EncoderMenu menu, Object recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        List<ResourceLocation> categories = PackagedAutoJEIPlugin.getRecipeCategoriesForRecipe(recipe);
        if (categories.isEmpty()) {
            return this.transferHelper.createInternalError();
        }
        IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
        if (!categories.stream().anyMatch(recipeType.getJEICategories()::contains)) {
            return this.transferHelper.createInternalError();
        }
        Int2ObjectMap<ItemStack> map = recipeType.getRecipeTransferMap(new RecipeSlotsViewWrapper(recipe, recipeSlots));
        if (map == null || map.isEmpty()) {
            return this.transferHelper.createInternalError();
        }
        if (!doTransfer) {
            return null;
        }
        PacketHandler.INSTANCE.sendToServer((Object)new SetRecipePacket(map));
        return null;
    }
}

