/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.emi;

import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.integration.emi.EmiRecipeWrapper;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.SetRecipePacket;

public class EncoderRecipeHandler
implements EmiRecipeHandler<EncoderMenu> {
    public EmiPlayerInventory getInventory(AbstractContainerScreen<EncoderMenu> screen) {
        return new EmiPlayerInventory(List.of());
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return true;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<EncoderMenu> context) {
        EncoderMenu menu = (EncoderMenu)context.getScreenHandler();
        IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
        ResourceLocation category = recipe.getCategory().getId();
        if (!recipeType.getEMICategories().contains(category)) {
            return false;
        }
        Int2ObjectMap<ItemStack> map = recipeType.getRecipeTransferMap(new EmiRecipeWrapper(recipe));
        return map != null && !map.isEmpty();
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<EncoderMenu> context) {
        if (!this.canCraft(recipe, context)) {
            return false;
        }
        recipe.getDisplayHeight();
        EncoderMenu menu = (EncoderMenu)context.getScreenHandler();
        IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
        Int2ObjectMap<ItemStack> map = recipeType.getRecipeTransferMap(new EmiRecipeWrapper(recipe));
        if (map == null || map.isEmpty()) {
            return false;
        }
        Minecraft.m_91087_().m_91152_((Screen)context.getScreen());
        PacketHandler.INSTANCE.sendToServer((Object)new SetRecipePacket(map));
        return true;
    }
}

