/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.DistributorBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEDistributorBlockEntity;
import thelm.packagedauto.inventory.DistributorItemHandler;
import thelm.packagedauto.item.DistributorMarkerItem;
import thelm.packagedauto.menu.DistributorMenu;
import thelm.packagedauto.network.packet.BeamPacket;
import thelm.packagedauto.network.packet.DirectionalMarkerPacket;
import thelm.packagedauto.network.packet.SizedMarkerPacket;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class DistributorBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine,
ISettingsCloneable {
    public static final BlockEntityType<DistributorBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AEDistributorBlockEntity::new, () -> () -> DistributorBlockEntity::new).get()), (Block[])new Block[]{DistributorBlock.INSTANCE}).m_58966_(null);
    public static int range = 16;
    public static int refreshInterval = 4;
    public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap(81);
    public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap(81);
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();

    public DistributorBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new DistributorItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedauto.distributor");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.distributor";
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % (long)refreshInterval == 0L && !this.pending.isEmpty()) {
            this.distributeItems();
        }
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        return this.acceptPackage(recipeInfo, stacks, direction, false);
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction, boolean blocking) {
        if (!this.isBusy() && recipeInfo instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo recipe = (IPositionedProcessingPackageRecipeInfo)recipeInfo;
            Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
            if (!this.positions.keySet().containsAll((IntCollection)matrix.keySet())) {
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                IVolumePackageItem vPackage;
                BlockPos pos = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).blockPos();
                if (!this.f_58857_.m_46749_(pos)) {
                    return false;
                }
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (blockEntity == null) {
                    return false;
                }
                ItemStack stack = ((ItemStack)entry.getValue()).m_41777_();
                Direction dir = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).direction();
                IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse(null);
                Item item = stack.m_41720_();
                if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, dir)) {
                    if (blocking && !vPackage.getVolumeType(stack).isEmpty((ICapabilityProvider)blockEntity, dir)) {
                        return false;
                    }
                    if (MiscHelper.INSTANCE.fillVolume(blockEntity, dir, stack, true).m_41619_()) continue;
                    return false;
                }
                if (itemHandler != null) {
                    if (blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler)) {
                        return false;
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true).m_41619_()) continue;
                    return false;
                }
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                this.pending.put(entry.getIntKey(), (Object)((ItemStack)entry.getValue()).m_41777_());
            }
            this.distributeItems();
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return !this.pending.isEmpty();
    }

    protected void distributeItems() {
        ArrayList<Vec3> deltas = new ArrayList<Vec3>();
        for (int i : this.pending.keySet().toIntArray()) {
            IVolumePackageItem vPackage;
            if (!this.positions.containsKey(i)) {
                this.ejectItems();
                break;
            }
            BlockPos pos = ((DirectionalGlobalPos)this.positions.get(i)).blockPos();
            if (!this.f_58857_.m_46749_(pos)) continue;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (blockEntity == null) {
                this.ejectItems();
                break;
            }
            ItemStack stack = (ItemStack)this.pending.get(i);
            Direction dir = ((DirectionalGlobalPos)this.positions.get(i)).direction();
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse(null);
            ItemStack stackRem = stack;
            Item item = stack.m_41720_();
            if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, dir)) {
                stackRem = MiscHelper.INSTANCE.fillVolume(blockEntity, dir, stack, false);
            } else if (itemHandler != null) {
                stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            } else {
                this.ejectItems();
                break;
            }
            if (stackRem.m_41613_() < stack.m_41613_()) {
                Vec3 delta = Vec3.m_82528_((Vec3i)pos.m_121996_((Vec3i)this.f_58858_)).m_82549_(Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82490_(0.5));
                deltas.add(delta);
            }
            if (stackRem.m_41619_()) {
                this.pending.remove(i);
                continue;
            }
            this.pending.put(i, (Object)stackRem);
        }
        if (!deltas.isEmpty()) {
            Vec3 source = Vec3.m_82512_((Vec3i)this.f_58858_);
            BeamPacket.sendBeams(source, deltas, 65535, 6, true, (ResourceKey<Level>)this.f_58857_.m_46472_(), 32.0);
            this.m_6596_();
        }
    }

    protected void ejectItems() {
        for (int i = 0; i < 81; ++i) {
            ItemStack stack;
            if (!this.pending.containsKey(i) || (stack = (ItemStack)this.pending.remove(i)).m_41619_()) continue;
            double dx = (double)(this.f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
            double dy = (double)(this.f_58857_.f_46441_.m_188501_() / 2.0f) + 0.75;
            double dz = (double)(this.f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + dx, (double)this.f_58858_.m_123342_() + dy, (double)this.f_58858_.m_123343_() + dz, stack);
            itemEntity.m_32060_();
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
        this.m_6596_();
    }

    public void sendPreview(ServerPlayer player) {
        long currentTime = this.f_58857_.m_46467_();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.m_20148_());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            this.previewTimes.put((Object)player.m_20148_(), (Object)currentTime);
            if (!this.positions.isEmpty()) {
                List<Vec3> deltas = this.positions.values().stream().map(globalPos -> {
                    BlockPos pos = globalPos.blockPos();
                    Direction dir = globalPos.direction();
                    return Vec3.m_82528_((Vec3i)pos.m_121996_((Vec3i)this.f_58858_)).m_82549_(Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82490_(0.5));
                }).collect(Collectors.toList());
                Vec3 source = Vec3.m_82512_((Vec3i)this.f_58858_);
                DirectionalMarkerPacket.sendDirectionalMarkers(player, new ArrayList<DirectionalGlobalPos>((Collection<DirectionalGlobalPos>)this.positions.values()), 65407, 200);
                BeamPacket.sendBeams(player, source, deltas, 65407, 200, false);
            }
            Vec3 lowerCorner = Vec3.m_82528_((Vec3i)this.f_58858_).m_82492_((double)range, (double)range, (double)range);
            Vec3 size = new Vec3((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 65535, 200);
        }
    }

    @Override
    public int getComparatorSignal() {
        if (!this.pending.isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
        ItemStack stack;
        int i;
        Inventory playerInventory;
        int requiredCount;
        ListTag positionsTag;
        block13: {
            ItemStack stack2;
            int i2;
            positionsTag = nbt.m_128437_("Positions", 10);
            if (positionsTag.isEmpty()) {
                return ISettingsCloneable.Result.fail((Component)Component.m_237115_((String)"item.packagedauto.settings_cloner.invalid"));
            }
            requiredCount = positionsTag.size();
            int availableCount = 0;
            playerInventory = player.m_150109_();
            for (i2 = 0; i2 < this.itemHandler.getSlots(); ++i2) {
                stack2 = this.itemHandler.getStackInSlot(i2);
                if (stack2.m_41619_()) continue;
                if (stack2.m_150930_((Item)DistributorMarkerItem.INSTANCE)) {
                    availableCount += stack2.m_41613_();
                    continue;
                }
                return ISettingsCloneable.Result.fail((Component)Component.m_237115_((String)"block.packagedauto.distributor.non_marker_present"));
            }
            if (availableCount < requiredCount) {
                for (i2 = 0; i2 < playerInventory.m_6643_(); ++i2) {
                    stack2 = playerInventory.m_8020_(i2);
                    if (!stack2.m_41619_() && stack2.m_150930_((Item)DistributorMarkerItem.INSTANCE) && !stack2.m_41782_()) {
                        availableCount += stack2.m_41613_();
                    }
                    if (availableCount < requiredCount) {
                        continue;
                    }
                    break block13;
                }
                return ISettingsCloneable.Result.fail((Component)Component.m_237115_((String)"block.packagedauto.distributor.no_markers"));
            }
        }
        int removedCount = 0;
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            removedCount += this.itemHandler.getStackInSlot(i).m_41613_();
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        if (removedCount < requiredCount) {
            for (i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack stack3 = playerInventory.m_8020_(i);
                if (!stack3.m_41619_() && stack3.m_150930_((Item)DistributorMarkerItem.INSTANCE) && !stack3.m_41782_()) {
                    removedCount += stack3.m_41620_(requiredCount - removedCount).m_41613_();
                }
                if (removedCount >= requiredCount) break;
            }
        }
        if (removedCount > requiredCount && !playerInventory.m_36054_(stack = new ItemStack((ItemLike)DistributorMarkerItem.INSTANCE, removedCount - requiredCount))) {
            ItemEntity item = new ItemEntity(this.f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
            item.m_32052_(player.m_20148_());
            this.f_58857_.m_7967_((Entity)item);
        }
        for (int i3 = 0; i3 < requiredCount; ++i3) {
            CompoundTag positionTag = positionsTag.m_128728_(i3);
            byte index = positionTag.m_128445_("Index");
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(positionTag.m_128461_("Dimension")));
            int[] posArray = positionTag.m_128465_("Position");
            BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            Direction direction = Direction.m_122376_((int)positionTag.m_128445_("Direction"));
            DirectionalGlobalPos globalPos = new DirectionalGlobalPos((ResourceKey<Level>)dimension, blockPos, direction);
            ItemStack stack4 = new ItemStack((ItemLike)DistributorMarkerItem.INSTANCE);
            DistributorMarkerItem.INSTANCE.setDirectionalGlobalPos(stack4, globalPos);
            this.itemHandler.setStackInSlot(index, stack4);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
        if (this.positions.isEmpty()) {
            return ISettingsCloneable.Result.fail((Component)Component.m_237115_((String)"block.packagedauto.distributor.empty"));
        }
        ListTag positionsTag = new ListTag();
        for (Int2ObjectMap.Entry entry : this.positions.int2ObjectEntrySet()) {
            DirectionalGlobalPos pos = (DirectionalGlobalPos)entry.getValue();
            CompoundTag positionTag = new CompoundTag();
            positionTag.m_128344_("Index", (byte)entry.getIntKey());
            positionTag.m_128359_("Dimension", pos.dimension().m_135782_().toString());
            positionTag.m_128385_("Position", new int[]{pos.x(), pos.y(), pos.z()});
            positionTag.m_128344_("Direction", (byte)pos.direction().m_122411_());
            positionsTag.add((Object)positionTag);
        }
        nbt.m_128365_("Positions", (Tag)positionsTag);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.pending.clear();
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Pending", 10), pendingList);
        for (int i = 0; i < 81 && i < pendingList.size(); ++i) {
            ItemStack stack = (ItemStack)pendingList.get(i);
            if (stack.m_41619_()) continue;
            this.pending.put(i, (Object)stack);
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            pendingList.add((ItemStack)this.pending.getOrDefault(i, (Object)ItemStack.f_41583_));
        }
        ListTag pendingTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), pendingList);
        nbt.m_128365_("Pending", (Tag)pendingTag);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new DistributorMenu(windowId, inventory, this);
    }
}

