/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.theoneprobe;

import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.integration.lookingat.LookingAtHelper;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.integration.lookingat.theoneprobe.ProbeConfigProvider;
import mekanism.common.integration.lookingat.theoneprobe.TOPChemicalElement;
import mekanism.common.integration.lookingat.theoneprobe.TOPEnergyElement;
import mekanism.common.integration.lookingat.theoneprobe.TOPEntityProvider;
import mekanism.common.integration.lookingat.theoneprobe.TOPFluidElement;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class TOPProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    private BooleanSupplier displayFluidTanks;
    private Supplier<IProbeConfig.ConfigMode> tankMode = () -> IProbeConfig.ConfigMode.EXTENDED;

    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerEntityProvider((IProbeInfoEntityProvider)TOPEntityProvider.INSTANCE);
        probe.registerProbeConfigProvider((IProbeConfigProvider)ProbeConfigProvider.INSTANCE);
        probe.registerElementFactory((IElementFactory)new TOPEnergyElement.Factory());
        probe.registerElementFactory((IElementFactory)new TOPFluidElement.Factory());
        probe.registerElementFactory((IElementFactory)new TOPChemicalElement.GasElementFactory());
        probe.registerElementFactory((IElementFactory)new TOPChemicalElement.InfuseTypeElementFactory());
        probe.registerElementFactory((IElementFactory)new TOPChemicalElement.PigmentElementFactory());
        probe.registerElementFactory((IElementFactory)new TOPChemicalElement.SlurryElementFactory());
        IProbeConfig probeConfig = probe.createProbeConfig();
        this.displayFluidTanks = () -> probeConfig.getTankMode() > 0;
        this.tankMode = () -> ((IProbeConfig)probeConfig).getShowTankSetting();
        return null;
    }

    public ResourceLocation getID() {
        return Mekanism.rl("data");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity tile;
        BlockPos mainPos;
        BlockPos pos = data.getPos();
        if (blockState.m_60734_() instanceof BlockBounding && (mainPos = BlockBounding.getMainBlockPos((BlockGetter)world, pos)) != null) {
            pos = mainPos;
        }
        if ((tile = WorldUtils.getTileEntity((BlockGetter)world, pos)) != null) {
            LookingAtUtils.addInfo(new TOPLookingAtHelper(info), tile, this.displayTanks(mode), this.displayFluidTanks.getAsBoolean());
        }
    }

    private boolean displayTanks(ProbeMode mode) {
        return switch (this.tankMode.get()) {
            default -> throw new IncompatibleClassChangeError();
            case IProbeConfig.ConfigMode.NOT -> false;
            case IProbeConfig.ConfigMode.NORMAL -> {
                if (mode == ProbeMode.NORMAL) {
                    yield true;
                }
                yield false;
            }
            case IProbeConfig.ConfigMode.EXTENDED -> mode == ProbeMode.EXTENDED;
        };
    }

    static class TOPLookingAtHelper
    implements LookingAtHelper {
        private final IProbeInfo info;

        public TOPLookingAtHelper(IProbeInfo info) {
            this.info = info;
        }

        @Override
        public void addText(Component text) {
            this.info.text(CompoundText.create().name(text).get());
        }

        @Override
        public void addEnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
            this.info.element((IElement)new TOPEnergyElement(energy, maxEnergy));
        }

        @Override
        public void addFluidElement(FluidStack stored, int capacity) {
            this.info.element((IElement)new TOPFluidElement(stored, capacity));
        }

        @Override
        public void addChemicalElement(ChemicalStack<?> stored, long capacity) {
            TOPChemicalElement element = TOPChemicalElement.create(stored, capacity);
            if (element != null) {
                this.info.element((IElement)element);
            }
        }
    }
}

