/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.game;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ComponentUtil {
    private static final HoverEvent HOVER_COPY = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"libx.misc.copy"));

    public static String getConsoleString(Component tc) {
        StringBuilder sb = new StringBuilder();
        tc.m_7451_((style, string) -> {
            ComponentUtil.reset(sb);
            ComponentUtil.formattingCodes(sb, style);
            sb.append(string);
            return Optional.empty();
        }, Style.f_131099_);
        ComponentUtil.reset(sb);
        return sb.toString();
    }

    private static void formattingCodes(StringBuilder sb, Style style) {
        if (style.m_131135_() != null) {
            int color = style.m_131135_().f_131257_;
            sb.append("\u001b[38;2;").append(color >> 16 & 0xFF).append(";").append(color >> 8 & 0xFF).append(";").append(color & 0xFF).append("m");
        }
        if (style.f_131102_ != null) {
            if (style.f_131102_.booleanValue()) {
                sb.append("\u001b[1m");
            } else {
                sb.append("\u001b[22m");
            }
        }
        if (style.f_131103_ != null) {
            if (style.f_131103_.booleanValue()) {
                sb.append("\u001b[3m");
            } else {
                sb.append("\u001b[23m");
            }
        }
        if (style.f_131104_ != null) {
            if (style.f_131104_.booleanValue()) {
                sb.append("\u001b[4m");
            } else {
                sb.append("\u001b[24m");
            }
        }
        if (style.f_131105_ != null) {
            if (style.f_131105_.booleanValue()) {
                sb.append("\u001b[9m");
            } else {
                sb.append("\u001b[29m");
            }
        }
        if (style.f_131106_ != null) {
            if (style.f_131106_.booleanValue()) {
                sb.append("\u001b[8m");
            } else {
                sb.append("\u001b[28m");
            }
        }
    }

    private static void reset(StringBuilder sb) {
        sb.append("\u001b[0m");
    }

    public static Component toPrettyComponent(JsonElement json) {
        if (json.isJsonNull()) {
            return Component.m_237113_((String)"null").m_130940_(ChatFormatting.RED);
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isString()) {
                return Component.m_237113_((String)primitive.toString()).m_130940_(ChatFormatting.GREEN);
            }
            return Component.m_237113_((String)primitive.toString()).m_130940_(ChatFormatting.GOLD);
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            MutableComponent tc = Component.m_237113_((String)"[");
            boolean first = true;
            for (JsonElement element : array) {
                if (first) {
                    first = false;
                } else {
                    tc.m_7220_((Component)Component.m_237113_((String)", "));
                }
                tc = tc.m_7220_(ComponentUtil.toPrettyComponent(element));
            }
            tc = tc.m_7220_((Component)Component.m_237113_((String)"]"));
            return tc;
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            MutableComponent tc = Component.m_237113_((String)"{");
            boolean first = true;
            for (Map.Entry entry : object.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    tc.m_7220_((Component)Component.m_237113_((String)", "));
                }
                tc = tc.m_7220_((Component)Component.m_237113_((String)new JsonPrimitive((String)entry.getKey()).toString()).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_(ComponentUtil.toPrettyComponent((JsonElement)entry.getValue()));
            }
            tc = tc.m_7220_((Component)Component.m_237113_((String)"}"));
            return tc;
        }
        throw new IllegalArgumentException("JSON type unknown: " + json.getClass());
    }

    public static Component withCopyAction(Component component, String copyText) {
        return component.m_6881_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copyText)).m_131144_(HOVER_COPY));
    }

    public static FormattedCharSequence subSequence(FormattedCharSequence text, int start) {
        if (start == 0) {
            return text;
        }
        return ComponentUtil.subSequence(text, start, 0x7FFFFFFE);
    }

    public static FormattedCharSequence subSequence(FormattedCharSequence text, int start, int end) {
        if (start < 0 || end < 0) {
            throw new IllegalArgumentException("Negative bounds");
        }
        if (end <= start) {
            return FormattedCharSequence.f_13691_;
        }
        return sink -> {
            AtomicInteger relOff = new AtomicInteger(0);
            AtomicInteger total = new AtomicInteger(0);
            return text.m_13731_((relPosition, style, codePoint) -> {
                int current = total.getAndIncrement();
                if (current == start) {
                    relOff.set(-relPosition);
                } else if (relPosition == 0) {
                    relOff.set(0);
                }
                if (current >= start && current < end) {
                    return sink.m_6411_(relPosition + relOff.get(), style, codePoint);
                }
                return true;
            });
        };
    }
}

