/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import snownee.kiwi.network.Networking;
import snownee.kiwi.network.PacketHandler;

public interface KPacketTarget {
    public static KPacketTarget tracking(Entity entity) {
        return () -> PacketDistributor.TRACKING_ENTITY.with(() -> entity);
    }

    public static KPacketTarget tracking(BlockEntity blockEntity) {
        return KPacketTarget.tracking((ServerLevel)Objects.requireNonNull(blockEntity.m_58904_()), blockEntity.m_58899_());
    }

    public static KPacketTarget tracking(ServerLevel level, ChunkPos chunkPos) {
        return () -> PacketDistributor.TRACKING_CHUNK.with(() -> level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_));
    }

    public static KPacketTarget tracking(ServerLevel level, BlockPos blockPos) {
        return KPacketTarget.tracking(level, new ChunkPos(blockPos));
    }

    public static KPacketTarget world(ServerLevel level) {
        return () -> PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_());
    }

    public static KPacketTarget all(MinecraftServer server) {
        return () -> ((PacketDistributor)PacketDistributor.ALL).noArg();
    }

    public static KPacketTarget allExcept(ServerPlayer player) {
        return () -> Networking.ALL_EXCEPT.with(() -> player);
    }

    public static KPacketTarget around(ServerLevel world, Vec3 pos, double radius) {
        return () -> PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (double)radius, (ResourceKey)world.m_46472_()));
    }

    public static KPacketTarget around(ServerLevel world, Vec3i pos, double radius) {
        return KPacketTarget.around(world, Vec3.m_82512_((Vec3i)pos), radius);
    }

    default public void send(PacketHandler handler, Consumer<FriendlyByteBuf> buf) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer()).m_130085_(handler.id);
        buf.accept(buffer);
        Networking.send(this.internal(), buffer);
    }

    public PacketDistributor.PacketTarget internal();
}

