/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.voluminousenergy.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondChance;
    public final int time;
    public final int minExperience;
    public final int maxExperience;

    public CrushingRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int time, int minExperience, int maxExperience) {
        this(key, input, inputCount, output, outputCount, ItemStack.f_41583_, 0, 0.0f, time, minExperience, maxExperience);
    }

    public CrushingRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondChance, int time, int minExperience, int maxExperience) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
        this.time = time;
        this.minExperience = minExperience;
        this.maxExperience = maxExperience;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        JsonObject json = new JsonObject();
        json.addProperty("type", "voluminousenergy:crushing");
        JsonObject ingJson = MiscHelper.INSTANCE.wrapIngredient(ing).m_43942_().getAsJsonObject();
        ingJson.addProperty("count", (Number)this.inputCount);
        json.add("ingredient", (JsonElement)ingJson);
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        JsonObject secondJson = MiscHelper.INSTANCE.serializeItemStack(secondStack);
        secondJson.addProperty("chance", (Number)Float.valueOf(this.secondChance));
        json.add("rng", (JsonElement)secondJson);
        json.addProperty("process_time", (Number)this.time);
        JsonObject experienceJson = new JsonObject();
        experienceJson.addProperty("minimum", (Number)this.minExperience);
        experienceJson.addProperty("maximum", (Number)this.maxExperience);
        json.add("experience", (JsonElement)experienceJson);
        return json;
    }
}

