/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.railcraft.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class CrusherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int time;
    public final Object[] output;

    public CrusherRecipeSerializer(ResourceLocation key, Object input, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.time = time;
        this.output = Objects.requireNonNull(output);
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ArrayList<Triple> outputs = new ArrayList<Triple>();
        int i = 0;
        while (i < this.output.length) {
            Ingredient is;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getIngredient(out)) == EmptyIngredient.INSTANCE) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(Triple.of((Object)is, (Object)count, (Object)chance));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "railcraft:crusher");
        json.add("ingredient", ing.m_43942_());
        JsonArray outputJson = new JsonArray();
        for (Triple triple : outputs) {
            JsonObject resultJson = new JsonObject();
            resultJson.add("result", ((Ingredient)triple.getLeft()).m_43942_());
            resultJson.addProperty("count", (Number)triple.getMiddle());
            resultJson.addProperty("probability", (Number)triple.getRight());
            outputJson.add((JsonElement)resultJson);
        }
        json.add("outputs", (JsonElement)outputJson);
        json.addProperty("processTime", (Number)this.time);
        return json;
    }
}

