/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class MineralWasherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputAmount;
    public final double experience;
    public final int time;
    public final double energy;

    public MineralWasherRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double experience, int time, double energy) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputAmount = outputAmount;
        this.experience = experience;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        JsonObject fluidIngJson;
        JsonObject itemIngJson;
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "electrodynamics:mineral_washer_recipe");
        JsonObject itemInputJson = new JsonObject();
        itemInputJson.addProperty("count", (Number)1);
        if (this.itemInput instanceof String || this.itemInput instanceof ResourceLocation) {
            itemIngJson = new JsonObject();
            itemIngJson.addProperty("tag", this.itemInput.toString());
            itemIngJson.addProperty("count", (Number)this.itemInputCount);
        } else {
            ItemStack ing = MiscHelper.INSTANCE.getItemStack(this.itemInput, this.itemInputCount);
            itemIngJson = MiscHelper.INSTANCE.serializeItemStack(ing);
        }
        itemInputJson.add("0", (JsonElement)itemIngJson);
        json.add("iteminputs", (JsonElement)itemInputJson);
        JsonObject fluidInputJson = new JsonObject();
        fluidInputJson.addProperty("count", (Number)1);
        if (this.fluidInput instanceof String || this.fluidInput instanceof ResourceLocation) {
            fluidIngJson = new JsonObject();
            fluidIngJson.addProperty("tag", this.fluidInput.toString());
            fluidIngJson.addProperty("amount", (Number)this.fluidInputAmount);
        } else {
            FluidStack ing = MiscHelper.INSTANCE.getFluidStack(this.fluidInput, this.fluidInputAmount);
            fluidIngJson = MiscHelper.INSTANCE.serializeFluidStack(ing);
        }
        fluidInputJson.add("0", (JsonElement)fluidIngJson);
        json.add("fluidinputs", (JsonElement)fluidInputJson);
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeFluidStack(stack));
        json.addProperty("experience", (Number)this.experience);
        json.addProperty("ticks", (Number)this.time);
        json.addProperty("usagepertick", (Number)this.energy);
        return json;
    }
}

