/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluids;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;

public abstract class PlaceableFluid
extends Fluid {
    public static final float EIGHT_NINTHS = 0.8888889f;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(200){

            protected void rehash(int newN) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    protected final StateDefinition<Fluid, FluidState> stateDefinition;
    private final Map<FluidState, VoxelShape> shapeMap = new IdentityHashMap<FluidState, VoxelShape>();
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;

    public PlaceableFluid(int maxLevel) {
        this.maxLevel = maxLevel;
        this.levelProperty = IntegerProperty.m_61631_((String)"level", (int)1, (int)(maxLevel + 1));
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.m_7180_((StateDefinition.Builder<Fluid, FluidState>)builder);
        this.stateDefinition = builder.m_61101_(Fluid::m_76145_, FluidState::new);
        this.m_76142_((FluidState)((FluidState)this.stateDefinition.m_61090_()).m_61124_((Property)this.levelProperty, (Comparable)Integer.valueOf(maxLevel)));
    }

    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
        if (this.levelProperty != null) {
            builder.m_61104_(new Property[]{this.levelProperty});
        }
    }

    public StateDefinition<Fluid, FluidState> m_76144_() {
        return this.stateDefinition;
    }

    protected boolean m_5486_(FluidState fluidState, BlockGetter world, BlockPos pos, Fluid fluid, Direction face) {
        return face == Direction.DOWN && !this.m_6212_(fluid);
    }

    protected abstract int getDropOff(LevelReader var1);

    protected BlockState m_5804_(FluidState fluidState) {
        PlaceableFluidBlock block = this.getFluidBlock();
        IntegerProperty blockLevelProperty = block.getLevelProperty();
        int fluidLevel = (Integer)fluidState.m_61143_((Property)this.levelProperty);
        int blockLevel = fluidLevel > this.maxLevel ? this.maxLevel : this.maxLevel - fluidLevel;
        return (BlockState)block.m_49966_().m_61124_((Property)blockLevelProperty, (Comparable)Integer.valueOf(blockLevel));
    }

    protected abstract PlaceableFluidBlock getFluidBlock();

    protected Vec3 m_7000_(BlockGetter world, BlockPos pos, FluidState state) {
        double x = 0.0;
        double y = 0.0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            mutablePos.m_122159_((Vec3i)pos, offset);
            FluidState offsetState = world.m_6425_((BlockPos)mutablePos);
            if (!this.affectsFlow(offsetState)) continue;
            float offsetHeight = offsetState.m_76182_();
            float heightDiff = 0.0f;
            if (offsetHeight == 0.0f) {
                BlockPos posDown;
                FluidState belowState;
                if (!world.m_8055_((BlockPos)mutablePos).m_280555_() && this.affectsFlow(belowState = world.m_6425_(posDown = mutablePos.m_7495_())) && (offsetHeight = belowState.m_76182_()) > 0.0f) {
                    heightDiff = state.m_76182_() - offsetHeight + 0.8888889f;
                }
            } else if (offsetHeight > 0.0f) {
                heightDiff = state.m_76182_() - offsetHeight;
            }
            if (heightDiff == 0.0f) continue;
            x += (double)((float)offset.m_122429_() * heightDiff);
            y += (double)((float)offset.m_122431_() * heightDiff);
        }
        Vec3 flow = new Vec3(x, 0.0, y);
        if ((Integer)state.m_61143_((Property)this.levelProperty) == 0) {
            for (Direction offset : Direction.Plane.HORIZONTAL) {
                mutablePos.m_122159_((Vec3i)pos, offset);
                if (!this.isSolidFace(world, (BlockPos)mutablePos, offset) && !this.isSolidFace(world, mutablePos.m_7494_(), offset)) continue;
                flow = flow.m_82541_().m_82520_(0.0, -6.0, 0.0);
                break;
            }
        }
        return flow.m_82541_();
    }

    private boolean affectsFlow(FluidState otherState) {
        return otherState.m_76178_() || otherState.m_76152_().m_6212_((Fluid)this);
    }

    protected boolean isSolidFace(BlockGetter world, BlockPos pos, Direction face) {
        BlockState blockState = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        return !fluidState.m_76152_().m_6212_((Fluid)this) && (face == Direction.UP || !(blockState.m_60734_() instanceof IceBlock) && blockState.m_60783_(world, pos, face));
    }

    protected void spread(Level world, BlockPos pos, FluidState fluidState) {
        if (!fluidState.m_76178_()) {
            BlockState blockState = world.m_8055_(pos);
            BlockPos downPos = pos.m_7495_();
            BlockState downBlockState = world.m_8055_(downPos);
            FluidState newFluidState = this.getNewLiquid(world, downPos, downBlockState);
            if (this.canSpreadTo((BlockGetter)world, pos, blockState, Direction.DOWN, downPos, downBlockState, world.m_6425_(downPos), newFluidState.m_76152_())) {
                this.spreadTo((LevelAccessor)world, downPos, downBlockState, Direction.DOWN, newFluidState);
                if (this.sourceNeighborCount((LevelReader)world, pos) >= 3) {
                    this.spreadToSides(world, pos, fluidState, blockState);
                }
            } else if (fluidState.m_76170_() || !this.isWaterHole((BlockGetter)world, newFluidState.m_76152_(), pos, blockState, downPos, downBlockState)) {
                this.spreadToSides(world, pos, fluidState, blockState);
            }
        }
    }

    protected void spreadToSides(Level world, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int i = fluidState.m_76186_() - this.getDropOff((LevelReader)world);
        if (i > 0) {
            Map<Direction, FluidState> map = this.getSpread(world, pos, blockState);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                BlockState offsetBlockState;
                Direction direction = entry.getKey();
                FluidState offsetFluidState = entry.getValue();
                BlockPos offsetPos = pos.m_121945_(direction);
                if (!this.canSpreadTo((BlockGetter)world, pos, blockState, direction, offsetPos, offsetBlockState = world.m_8055_(offsetPos), world.m_6425_(offsetPos), offsetFluidState.m_76152_())) continue;
                this.spreadTo((LevelAccessor)world, offsetPos, offsetBlockState, direction, offsetFluidState);
            }
        }
    }

    protected FluidState getNewLiquid(Level world, BlockPos pos, BlockState blockState) {
        BlockPos upPos;
        BlockState upBlockState;
        FluidState upFluidState;
        int i = 0;
        int j = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.m_121945_(direction);
            BlockState offsetBlockState = world.m_8055_(offsetPos);
            FluidState offsetFluidState = offsetBlockState.m_60819_();
            if (!offsetFluidState.m_76152_().m_6212_((Fluid)this) || !this.canPassThroughWall(direction, (BlockGetter)world, pos, blockState, offsetPos, offsetBlockState)) continue;
            if (offsetFluidState.m_76170_() && ForgeEventFactory.canCreateFluidSource((Level)world, (BlockPos)pos, (BlockState)blockState, (boolean)offsetFluidState.canConvertToSource(world, offsetPos))) {
                ++j;
            }
            i = Math.max(i, offsetFluidState.m_76186_());
        }
        if (j >= 2) {
            BlockState blockstate1 = world.m_8055_(pos.m_7495_());
            FluidState FluidState1 = blockstate1.m_60819_();
            if (blockstate1.m_280296_() || this.isSourceBlockOfThisType(FluidState1)) {
                return (FluidState)this.m_76145_().m_61124_((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
            }
        }
        if (!(upFluidState = (upBlockState = world.m_8055_(upPos = pos.m_7494_())).m_60819_()).m_76178_() && upFluidState.m_76152_().m_6212_((Fluid)this) && this.canPassThroughWall(Direction.UP, (BlockGetter)world, pos, blockState, upPos, upBlockState)) {
            return (FluidState)this.m_76145_().m_61124_((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel + 1));
        }
        int k = i - this.getDropOff((LevelReader)world);
        if (k <= 0) {
            return Fluids.f_76191_.m_76145_();
        }
        return (FluidState)this.m_76145_().m_61124_((Property)this.levelProperty, (Comparable)Integer.valueOf(k));
    }

    protected boolean canPassThroughWall(Direction direction, BlockGetter world, BlockPos fromPos, BlockState fromBlockState, BlockPos toPos, BlockState toBlockState) {
        VoxelShape toShape;
        VoxelShape fromShape;
        boolean flag;
        Block.BlockStatePairKey cacheKey;
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cache = !fromBlockState.m_60734_().m_49967_() && !toBlockState.m_60734_().m_49967_() ? OCCLUSION_CACHE.get() : null;
        if (cache != null) {
            cacheKey = new Block.BlockStatePairKey(fromBlockState, toBlockState, direction);
            byte b0 = cache.getAndMoveToFirst((Object)cacheKey);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            cacheKey = null;
        }
        boolean bl = flag = !Shapes.m_83152_((VoxelShape)(fromShape = fromBlockState.m_60812_(world, fromPos)), (VoxelShape)(toShape = toBlockState.m_60812_(world, toPos)), (Direction)direction);
        if (cache != null) {
            if (cache.size() == 200) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)cacheKey, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    protected void spreadTo(LevelAccessor world, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (blockState.m_60734_() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)blockState.m_60734_()).m_7361_(world, pos, blockState, fluidState);
        } else {
            if (!blockState.m_60795_()) {
                this.beforeDestroyingBlock(world, pos, blockState);
            }
            world.m_7731_(pos, fluidState.m_76188_(), 3);
        }
    }

    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState blockState) {
        BlockEntity tile = blockState.m_155947_() ? world.m_7702_(pos) : null;
        Block.m_49892_((BlockState)blockState, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tile);
    }

    protected static short getCacheKey(BlockPos pos, BlockPos otherPos) {
        int dx = otherPos.m_123341_() - pos.m_123341_();
        int dz = otherPos.m_123343_() - pos.m_123343_();
        return (short)((dx + 128 & 0xFF) << 8 | dz + 128 & 0xFF);
    }

    protected Map<Direction, FluidState> getSpread(Level world, BlockPos pos, BlockState blockState) {
        int i = 1000;
        EnumMap<Direction, FluidState> map = new EnumMap<Direction, FluidState>(Direction.class);
        Short2ObjectOpenHashMap stateMap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap isWaterHoleMap = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.m_121945_(direction);
            short key = PlaceableFluid.getCacheKey(pos, offsetPos);
            Pair offsetState = (Pair)stateMap.computeIfAbsent(key, k -> {
                BlockState offsetBlockState = world.m_8055_(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.m_60819_());
            });
            BlockState offsetBlockState = (BlockState)offsetState.getLeft();
            FluidState offsetFluidState = (FluidState)offsetState.getRight();
            FluidState newOffsetFluidState = this.getNewLiquid(world, offsetPos, offsetBlockState);
            if (!this.canFlowSource((BlockGetter)world, newOffsetFluidState.m_76152_(), pos, blockState, direction, offsetPos, offsetBlockState, offsetFluidState)) continue;
            boolean flag = isWaterHoleMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.m_7495_();
                BlockState offsetDownState = world.m_8055_(offsetDownPos);
                return this.isWaterHole((BlockGetter)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            int j = 0;
            if (!flag) {
                j = this.getSlopeDistance((LevelReader)world, offsetPos, 1, direction.m_122424_(), offsetBlockState, pos, (Short2ObjectMap<Pair<BlockState, FluidState>>)stateMap, (Short2BooleanMap)isWaterHoleMap);
            }
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, newOffsetFluidState);
            i = j;
        }
        return map;
    }

    protected int getSlopeDistance(LevelReader world, BlockPos pos, int distance, Direction fromDirection, BlockState blockState, BlockPos startPos, Short2ObjectMap<Pair<BlockState, FluidState>> stateMap, Short2BooleanMap isWaterHoleMap) {
        int i = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            FluidState offsetFluidstate;
            short key;
            Pair pair;
            BlockState offsetBlockState;
            BlockPos offsetPos;
            if (direction == fromDirection || !this.canFlowSource((BlockGetter)world, this, pos, blockState, direction, offsetPos = pos.m_121945_(direction), offsetBlockState = (BlockState)(pair = (Pair)stateMap.computeIfAbsent(key = PlaceableFluid.getCacheKey(startPos, offsetPos), k -> {
                BlockState offsetBlockState = world.m_8055_(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.m_60819_());
            })).getLeft(), offsetFluidstate = (FluidState)pair.getRight())) continue;
            boolean flag = isWaterHoleMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.m_7495_();
                BlockState offsetDownState = world.m_8055_(offsetDownPos);
                return this.isWaterHole((BlockGetter)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            if (flag) {
                return distance;
            }
            if (distance >= this.getSlopeFindDistance(world) || (j = this.getSlopeDistance(world, offsetPos, distance + 1, direction.m_122424_(), offsetBlockState, startPos, stateMap, isWaterHoleMap)) >= i) continue;
            i = j;
        }
        return i;
    }

    protected boolean isSourceBlockOfThisType(FluidState fluidState) {
        return fluidState.m_76152_().m_6212_((Fluid)this) && fluidState.m_76170_();
    }

    protected int getSlopeFindDistance(LevelReader world) {
        return PlaceableFluid.ceilDiv(PlaceableFluid.ceilDiv(this.maxLevel, this.getDropOff(world)), 2);
    }

    protected int sourceNeighborCount(LevelReader world, BlockPos pos) {
        int count = 0;
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.m_121945_(offset);
            FluidState offsetState = world.m_6425_(offsetPos);
            if (!this.isSourceBlockOfThisType(offsetState)) continue;
            ++count;
        }
        return count;
    }

    protected boolean canHoldFluid(BlockGetter world, BlockPos pos, BlockState blockState, Fluid fluid) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            return ((LiquidBlockContainer)block).m_6044_(world, pos, blockState, fluid);
        }
        if (block instanceof DoorBlock || blockState.m_204336_(BlockTags.f_13068_) || block == Blocks.f_50155_ || block == Blocks.f_50130_ || block == Blocks.f_50628_) {
            return false;
        }
        return !blockState.m_60713_(Blocks.f_50142_) && !blockState.m_60713_(Blocks.f_50257_) && !blockState.m_60713_(Blocks.f_50446_) && !blockState.m_60713_(Blocks.f_50454_) && !blockState.m_280555_();
    }

    protected boolean canSpreadTo(BlockGetter world, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluid) {
        return toFluidState.m_76158_(world, toPos, fluid, direction) && this.canPassThroughWall(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canHoldFluid(world, toPos, toBlockState, fluid);
    }

    protected boolean canFlowSource(BlockGetter world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState) {
        return !this.isSourceBlockOfThisType(toFluidState) && this.canPassThroughWall(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canHoldFluid(world, toPos, toBlockState, fluid);
    }

    protected boolean isWaterHole(BlockGetter world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, BlockPos downPos, BlockState downState) {
        return this.canPassThroughWall(Direction.DOWN, world, fromPos, fromBlockState, downPos, downState) && (downState.m_60819_().m_76152_().m_6212_((Fluid)this) || this.canHoldFluid(world, downPos, downState, fluid));
    }

    protected int getDelay(Level world, BlockPos pos, FluidState fluidState, FluidState newFluidState) {
        return this.m_6718_((LevelReader)world);
    }

    public void m_6292_(Level world, BlockPos pos, FluidState fluidState) {
        if (!fluidState.m_76170_()) {
            FluidState newFluidState = this.getNewLiquid(world, pos, world.m_8055_(pos));
            int delay = this.getDelay(world, pos, fluidState, newFluidState);
            if (newFluidState.m_76178_()) {
                fluidState = newFluidState;
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            } else if (!newFluidState.equals(fluidState)) {
                fluidState = newFluidState;
                BlockState blockState = fluidState.m_76188_();
                world.m_7731_(pos, blockState, 2);
                world.m_186469_(pos, fluidState.m_76152_(), delay);
                world.m_46672_(pos, blockState.m_60734_());
            }
        }
        this.spread(world, pos, fluidState);
    }

    protected int getLegacyLevel(FluidState fluidState) {
        int level = (Integer)fluidState.m_61143_((Property)this.levelProperty);
        if (level > this.maxLevel) {
            return this.maxLevel;
        }
        return this.maxLevel - Math.min(fluidState.m_76186_(), this.maxLevel);
    }

    protected static boolean hasSameAbove(FluidState fluidState, BlockGetter world, BlockPos pos) {
        return fluidState.m_76152_().m_6212_(world.m_6425_(pos.m_7494_()).m_76152_());
    }

    public float m_6098_(FluidState fluidState, BlockGetter world, BlockPos pos) {
        return PlaceableFluid.hasSameAbove(fluidState, world, pos) ? 1.0f : fluidState.m_76182_();
    }

    public float m_7427_(FluidState fluidState) {
        return 0.9f * (float)fluidState.m_76186_() / (float)this.maxLevel;
    }

    public boolean m_7444_(FluidState fluidState) {
        return (Integer)fluidState.m_61143_((Property)this.levelProperty) == this.maxLevel;
    }

    public int m_7430_(FluidState fluidState) {
        return Math.min(this.maxLevel, (Integer)fluidState.m_61143_((Property)this.levelProperty));
    }

    public VoxelShape m_7999_(FluidState fluidState, BlockGetter world, BlockPos pos) {
        return this.shapeMap.computeIfAbsent(fluidState, s -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)s.m_76155_(world, pos), (double)1.0));
    }

    public Optional<SoundEvent> m_142520_() {
        return Optional.ofNullable(this.getFluidType().getSound(SoundActions.BUCKET_FILL));
    }

    public static int ceilDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) >= 0 && r * y != x) {
            ++r;
        }
        return r;
    }
}

