/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.lwjgl.opengl.GL11;

public class GLStencil
implements AutoCloseable {
    private static final GLStencil INSTANCE = new GLStencil();

    public static GLStencil of() {
        INSTANCE.initializeStencil();
        return INSTANCE;
    }

    public static boolean isEnabled() {
        return Minecraft.m_91087_().m_91385_().isStencilEnabled();
    }

    private GLStencil() {
    }

    private void initializeStencil() {
        RenderSystem.clearStencil((int)0);
        RenderSystem.stencilMask((int)255);
        RenderSystem.clear((int)1024, (boolean)true);
        GL11.glEnable((int)2960);
    }

    public void populateStencil(Runnable render) {
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.stencilFunc((int)519, (int)1, (int)255);
        RenderSystem.stencilMask((int)255);
        RenderSystem.stencilOp((int)7681, (int)7681, (int)7681);
        render.run();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
    }

    public void populateStencil(Consumer<VertexConsumer> renderer) {
        this.populateStencil(() -> {
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder b = tess.m_85915_();
            b.m_85730_();
            b.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            renderer.accept((VertexConsumer)b);
            tess.m_85914_();
        });
    }

    public void populateStencil(GuiGraphics src, Consumer<GuiGraphics> renderer) {
        src.m_280262_();
        this.populateStencil(() -> {
            Minecraft mc = Minecraft.m_91087_();
            GuiGraphics gfx = new GuiGraphics(mc, mc.m_91269_().m_110108_());
            PoseStack p = gfx.m_280168_();
            p.m_252931_(src.m_280168_().m_85850_().m_252922_());
            renderer.accept(gfx);
            gfx.m_280262_();
        });
    }

    public void renderWithStencil(Runnable job) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        job.run();
        RenderSystem.stencilFunc((int)519, (int)1, (int)255);
    }

    @Override
    public void close() {
        RenderSystem.assertOnRenderThread();
        GL11.glDisable((int)2960);
    }
}

