/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.annotation.ElementType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.io.NBTSerializer;
import org.zeith.hammerlib.api.io.serializers.BooleanSerializer;
import org.zeith.hammerlib.api.io.serializers.EnumNBTSerializer;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;
import org.zeith.hammerlib.api.io.serializers.NumberSerializer;
import org.zeith.hammerlib.api.io.serializers.RecordNBTSerializer;
import org.zeith.hammerlib.api.io.serializers.codec.CodecSerializer;
import org.zeith.hammerlib.api.io.serializers.codec.ICodecSerializer;
import org.zeith.hammerlib.core.scans.base.IAnnotationScanListener;
import org.zeith.hammerlib.core.scans.base.IScanListener;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class NBTSerializationHelper {
    public static final Logger LOG = LoggerFactory.getLogger((String)"HammerLib");
    private static final BiMap<Class<?>, INBTSerializer<?>> SERIALIZER_MAP = HashBiMap.create();
    private static final BiMap<Class<? extends Enum<?>>, INBTSerializer<?>> ENUM_SERIALIZER_MAP = HashBiMap.create();
    private static final BiMap<Class<? extends Record>, INBTSerializer<?>> RECORD_SERIALIZER_MAP = HashBiMap.create();

    public static <T> void registerCodecSerializer(ICodecSerializer<T> serializer) {
        NBTSerializationHelper.registerSerializer(serializer.type(), serializer.asSerializer());
    }

    public static <T> void registerSerializer(Class<T> type, INBTSerializer<T> serializer) {
        SERIALIZER_MAP.putIfAbsent(type, serializer);
    }

    public static IScanListener create() {
        return IAnnotationScanListener.forAnnotation(NBTSerializer.class, ElementType.TYPE, data -> data.getProperty("value").map(List.class::cast).ifPresentOrElse(ts -> {
            try {
                List types = (List)Cast.cast(ts);
                Constructor<?> ctor = data.getOwnerClass().getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                INBTSerializer ser = (INBTSerializer)Cast.cast(ctor.newInstance(new Object[0]));
                for (Type type : types) {
                    Class<?> c = ReflectionUtil.fetchClassAny(type);
                    if (c != null) {
                        SERIALIZER_MAP.putIfAbsent(c, (Object)ser);
                        LOG.debug("Registered NBT serializer for type {}: {}", c, (Object)ser);
                        continue;
                    }
                    LOG.error("Unable to find class {}!", (Object)type.getInternalName());
                }
            }
            catch (ReflectiveOperationException roe) {
                LOG.error("Failed to create an instance of {}", (Object)data.getOwnerClass().getName(), (Object)roe);
            }
        }, () -> LOG.error("Completely ignored broken @NBTSerializer annotation with data {}", (Object)data.parent.annotationData()))).then(IAnnotationScanListener.forAnnotation(CodecSerializer.class, ElementType.FIELD, data -> {
            Field field = ReflectionUtil.lookupField(data.getOwnerClass(), data.getMemberName());
            if (field == null) {
                LOG.error("Completely ignored invalid @CodecSerializer at {} {}. (field not found)", (Object)data.clazz(), (Object)data.getMemberName());
                return;
            }
            if (!Modifier.isStatic(field.getModifiers())) {
                LOG.error("Completely ignored invalid @CodecSerializer at {} {}. (field is not static)", (Object)data.clazz(), (Object)data.getMemberName());
                return;
            }
            ICodecSerializer codecSer = ReflectionUtil.fetchValue(field, null, ICodecSerializer.class).orElse(null);
            if (codecSer == null) {
                LOG.error("@CodecSerializer field at {} {} is not ICodecSerializer. (unable to obtain value that implements ICodecSerializer)", (Object)data.clazz(), (Object)data.getMemberName());
                return;
            }
            Class c = codecSer.type();
            INBTSerializer ser = codecSer.asSerializer();
            NBTSerializationHelper.registerCodecSerializer(codecSer);
            LOG.debug("Registered codec NBT serializer for type {}: {}", c, ser);
        }));
    }

    public static <T> INBTSerializer<T> getSerializer(Class<T> type) {
        if (type.isRecord()) {
            return (INBTSerializer)Cast.cast(RECORD_SERIALIZER_MAP.computeIfAbsent((Object)((Class)Cast.cast(type)), RecordNBTSerializer::new));
        }
        if (type.isEnum()) {
            return (INBTSerializer)Cast.cast(ENUM_SERIALIZER_MAP.computeIfAbsent((Object)((Class)Cast.cast(type)), EnumNBTSerializer::create));
        }
        return (INBTSerializer)Cast.cast(SERIALIZER_MAP.get(type));
    }

    public static void serializeField(Class<?> type, Object instance, CompoundTag nbt, String key) {
        if (instance == null) {
            return;
        }
        INBTSerializer<?> serializer = NBTSerializationHelper.getSerializer(type);
        if (serializer != null) {
            serializer.serialize(nbt, key, Cast.cast(instance));
        } else if (type.isArray()) {
            CompoundTag lst = new CompoundTag();
            Class<?> compType = type.getComponentType();
            int length = Array.getLength(instance);
            for (int i = 0; i < length; ++i) {
                Object component = Array.get(instance, i);
                NBTSerializationHelper.serializeField(compType, component, lst, Integer.toString(i));
            }
            nbt.m_128365_(key, (Tag)lst);
        } else {
            LOG.warn("Don't know how to serialize {} {}", type, (Object)key);
        }
    }

    public static Object deserializeField(Class<?> type, CompoundTag nbt, String key) {
        INBTSerializer<?> serializer = NBTSerializationHelper.getSerializer(type);
        if (serializer != null) {
            return serializer.deserialize(nbt, key);
        }
        if (type.isArray()) {
            if (nbt.m_128425_(key, 10)) {
                CompoundTag lst = nbt.m_128469_(key);
                Class<?> compType = type.getComponentType();
                int length = lst.m_128440_();
                Object instance = Array.newInstance(compType, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(instance, i, NBTSerializationHelper.deserializeField(compType, lst, Integer.toString(i)));
                }
                return instance;
            }
            return null;
        }
        LOG.warn("Don't know how to deserialize {} {}", type, (Object)key);
        return null;
    }

    public static CompoundTag serialize(Object instance) {
        Class<?> type = instance.getClass();
        CompoundTag nbt = new CompoundTag();
        for (Field field : ReflectionUtil.getFieldsUpTo(type, null)) {
            field.setAccessible(true);
            NBTSerializable nbts = field.getAnnotation(NBTSerializable.class);
            if (nbts == null) continue;
            String name = nbts.value();
            if (name.trim().isEmpty()) {
                name = field.getName();
            }
            try {
                if (Modifier.isFinal(field.getModifiers())) {
                    Object object = field.get(instance);
                    if (object instanceof INBTSerializable) {
                        INBTSerializable s = (INBTSerializable)object;
                        nbt.m_128365_(name, s.serializeNBT());
                        continue;
                    }
                    if (INBTSerializer.class.isAssignableFrom(field.getType())) continue;
                    LOG.warn("Don't know how to serialize {} in {}", (Object)field, type);
                    continue;
                }
                NBTSerializationHelper.serializeField(field.getType(), field.get(instance), nbt, name);
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Failed to serialize field {} in {}", new Object[]{field, type, e});
            }
        }
        return nbt;
    }

    public static void deserialize(Object instance, CompoundTag nbt) {
        Class<?> type = instance.getClass();
        for (Field field : ReflectionUtil.getFieldsUpTo(type, null)) {
            field.setAccessible(true);
            NBTSerializable nbts = field.getAnnotation(NBTSerializable.class);
            if (nbts == null) continue;
            String name = nbts.value();
            if (name.trim().isEmpty()) {
                name = field.getName();
            }
            try {
                if (Modifier.isFinal(field.getModifiers())) {
                    Object object = field.get(instance);
                    if (object instanceof INBTSerializable) {
                        INBTSerializable s = (INBTSerializable)object;
                        Tag tag = nbt.m_128423_(name);
                        if (tag == null) continue;
                        s.deserializeNBT(tag);
                        continue;
                    }
                    if (INBTSerializer.class.isAssignableFrom(field.getType())) {
                        if (!nbt.m_128441_(name)) continue;
                        LOG.warn("Can't deserialize {} in {} since the final value is null. Trying to deserialize tag: {}", new Object[]{field, type, nbt.m_128423_(name)});
                        continue;
                    }
                    LOG.warn("Don't know how to deserialize {} in {}", (Object)field, type);
                    continue;
                }
                Object val = NBTSerializationHelper.deserializeField(field.getType(), nbt, name);
                if (val == null && field.getType().isPrimitive()) continue;
                field.set(instance, val);
            }
            catch (Throwable e) {
                LOG.error("Failed to deserialize field {} in {}", new Object[]{field, type, e});
            }
        }
    }

    static {
        NBTSerializationHelper.registerSerializer(Boolean.class, new BooleanSerializer());
        NBTSerializationHelper.registerSerializer(Byte.class, new NumberSerializer<Byte, ByteTag>(1, ByteTag::m_128266_, ByteTag::m_7063_));
        NBTSerializationHelper.registerSerializer(Short.class, new NumberSerializer<Short, ShortTag>(2, ShortTag::m_129258_, ShortTag::m_7053_));
        NBTSerializationHelper.registerSerializer(Float.class, new NumberSerializer<Float, FloatTag>(5, FloatTag::m_128566_, FloatTag::m_7057_));
        NBTSerializationHelper.registerSerializer(Double.class, new NumberSerializer<Double, DoubleTag>(6, DoubleTag::m_128500_, DoubleTag::m_7061_));
        NBTSerializationHelper.registerSerializer(Integer.class, new NumberSerializer<Integer, IntTag>(3, IntTag::m_128679_, IntTag::m_7047_));
        NBTSerializationHelper.registerSerializer(Long.class, new NumberSerializer<Long, LongTag>(4, LongTag::m_128882_, LongTag::m_7046_));
        NBTSerializationHelper.registerSerializer(Boolean.TYPE, new BooleanSerializer());
        NBTSerializationHelper.registerSerializer(Byte.TYPE, new NumberSerializer<Byte, ByteTag>(1, ByteTag::m_128266_, ByteTag::m_7063_));
        NBTSerializationHelper.registerSerializer(Short.TYPE, new NumberSerializer<Short, ShortTag>(2, ShortTag::m_129258_, ShortTag::m_7053_));
        NBTSerializationHelper.registerSerializer(Float.TYPE, new NumberSerializer<Float, FloatTag>(5, FloatTag::m_128566_, FloatTag::m_7057_));
        NBTSerializationHelper.registerSerializer(Double.TYPE, new NumberSerializer<Double, DoubleTag>(6, DoubleTag::m_128500_, DoubleTag::m_7061_));
        NBTSerializationHelper.registerSerializer(Integer.TYPE, new NumberSerializer<Integer, IntTag>(3, IntTag::m_128679_, IntTag::m_7047_));
        NBTSerializationHelper.registerSerializer(Long.TYPE, new NumberSerializer<Long, LongTag>(4, LongTag::m_128882_, LongTag::m_7046_));
        NBTSerializationHelper.registerSerializer(BigInteger.class, new NumberSerializer<BigInteger, ByteArrayTag>(7, b -> new ByteArrayTag(b.toByteArray()), nbt -> new BigInteger(nbt.m_128227_())));
        NBTSerializationHelper.registerSerializer(BigDecimal.class, new NumberSerializer<BigDecimal, ByteArrayTag>(7, b -> new ByteArrayTag(b.toString().getBytes(StandardCharsets.UTF_8)), nbt -> new BigDecimal(new String(nbt.m_128227_(), StandardCharsets.UTF_8))));
    }
}

