/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.RecipeInventory;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.util.EmptyContainer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public abstract class AutoTableTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private WrappedRecipe recipe;
    private int progress;
    private boolean running = true;
    private boolean isGridChanged = true;

    public AutoTableTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Running", this.running);
        tag.m_128365_("Energy", this.getEnergy().serializeNBT());
        tag.m_128391_(this.getRecipeStorage().serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.running = tag.m_128471_("Running");
        this.getEnergy().deserializeNBT(tag.m_128423_("Energy"));
        this.getRecipeStorage().deserializeNBT(tag);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.getRecipeStorage().onLoad(this.f_58857_, (RecipeType<? extends Recipe<Container>>)((RecipeType)ModRecipeTypes.TABLE.get()));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == ForgeCapabilities.ENERGY) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyCapability);
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoTableTileEntity tile) {
        int selected;
        BaseEnergyStorage energy = tile.getEnergy();
        if (tile.running) {
            WrappedRecipe recipe = tile.getActiveRecipe();
            BaseItemStackHandler selectedRecipe = tile.getRecipeStorage().getSelectedRecipeGrid();
            if (recipe != null && (selectedRecipe == null || recipe.matchesSavedRecipe(selectedRecipe, level))) {
                RecipeInventory recipeInventory = tile.getRecipeInventory();
                BaseItemStackHandler inventory = tile.getInventory();
                ItemStack result = recipe.getCraftingResult((Container)recipeInventory, level.m_9598_());
                int outputSlot = inventory.getSlots() - 1;
                ItemStack output = inventory.getStackInSlot(outputSlot);
                int powerRate = (Integer)ModConfigs.AUTO_TABLE_POWER_RATE.get();
                if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output) && energy.getEnergyStored() >= powerRate) {
                    ++tile.progress;
                    energy.extractEnergy(powerRate, false);
                    if (tile.progress >= tile.getProgressRequired()) {
                        NonNullList<ItemStack> remaining = recipe.getRemainingItems((Container)recipeInventory);
                        for (int i = 0; i < recipeInventory.m_6643_(); ++i) {
                            inventory.setStackInSlot(i, StackHelper.shrink((ItemStack)inventory.getStackInSlot(i), (int)1, (boolean)false));
                            ItemStack remainingStack = (ItemStack)remaining.get(i);
                            ItemStack currentStack = inventory.getStackInSlot(i);
                            if (!StackHelper.canCombineStacks((ItemStack)remainingStack, (ItemStack)currentStack)) continue;
                            inventory.setStackInSlot(i, StackHelper.combineStacks((ItemStack)currentStack, (ItemStack)remainingStack));
                        }
                        tile.updateResult(result, outputSlot);
                        tile.progress = 0;
                        tile.isGridChanged = true;
                    }
                    tile.setChangedFast();
                }
            } else if (tile.progress > 0) {
                tile.progress = 0;
                tile.setChangedFast();
            }
        } else if (tile.progress > 0) {
            tile.progress = 0;
            tile.setChangedFast();
        }
        int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
        if (tile.getEnergy().getEnergyStored() >= insertPowerRate && (selected = tile.getRecipeStorage().getSelected()) != -1) {
            tile.getAboveInventory().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    boolean inserted;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || handler.extractItem(i, 1, true).m_41619_() || !(inserted = tile.tryInsertItemIntoGrid(stack))) continue;
                    handler.extractItem(i, 1, false);
                    break;
                }
            });
        }
        tile.dispatchIfChanged();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void toggleRunning() {
        this.running = !this.running;
        this.setChangedAndDispatch();
    }

    public void selectRecipe(int index) {
        this.getRecipeStorage().setSelected(index);
        this.setChangedAndDispatch();
    }

    public void saveRecipe(int index) {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        RecipeInventory inventory = this.getRecipeInventory();
        ITableRecipe recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TABLE.get(), (Container)inventory, level).orElse(null);
        ItemStack result = ItemStack.f_41583_;
        if (recipe != null) {
            result = recipe.m_5874_((Container)inventory, level.m_9598_());
        } else {
            ExtendedCraftingInventory craftingInventory = new ExtendedCraftingInventory(EmptyContainer.INSTANCE, this.getInventory(), 3, true);
            CraftingRecipe vanilla = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, level).orElse(null);
            if (vanilla != null) {
                result = vanilla.m_5874_((Container)craftingInventory, level.m_9598_());
            }
        }
        this.getRecipeStorage().setRecipe(index, (Container)inventory, result);
        this.setChangedAndDispatch();
    }

    public void deleteRecipe(int index) {
        this.getRecipeStorage().unsetRecipe(index);
        this.setChangedAndDispatch();
    }

    public RecipeInventory getRecipeInventory() {
        return this.getInventory().toRecipeInventory(0, this.getInventory().getSlots() - 1);
    }

    public WrappedRecipe getActiveRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        RecipeInventory inventory = this.getRecipeInventory();
        if (this.isGridChanged && (this.recipe == null || !this.recipe.matches((Container)inventory, this.f_58857_))) {
            ITableRecipe recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TABLE.get(), (Container)inventory, this.f_58857_).orElse(null);
            WrappedRecipe wrappedRecipe = this.recipe = recipe != null ? new WrappedRecipe(recipe) : null;
            if (this.recipe == null && ((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue() && this instanceof Basic) {
                ExtendedCraftingInventory craftingInventory = new ExtendedCraftingInventory(EmptyContainer.INSTANCE, this.getInventory(), 3, true);
                CraftingRecipe vanilla = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, this.f_58857_).orElse(null);
                this.recipe = vanilla != null ? new WrappedRecipe(vanilla, (CraftingContainer)craftingInventory) : null;
            }
            this.isGridChanged = false;
        }
        return this.recipe;
    }

    public abstract int getProgressRequired();

    public abstract TableRecipeStorage getRecipeStorage();

    public abstract BaseEnergyStorage getEnergy();

    protected void onContentsChanged() {
        this.isGridChanged = true;
        this.setChangedFast();
    }

    private void updateResult(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack result = inventory.getStackInSlot(inventory.getSlots() - 1);
        if (result.m_41619_()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)result, (int)stack.m_41613_()));
        }
    }

    private void addStackToSlot(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackInSlot = inventory.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)stackInSlot, (int)stack.m_41613_()));
        }
    }

    private LazyOptional<IItemHandler> getAboveInventory() {
        BlockEntity tile;
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_().m_7494_();
        if (level != null && (tile = level.m_7702_(pos)) != null) {
            return tile.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        }
        return LazyOptional.empty();
    }

    private boolean tryInsertItemIntoGrid(ItemStack input) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackToPut = ItemStack.f_41583_;
        BaseItemStackHandler recipe = this.getRecipeStorage().getSelectedRecipe();
        int slotToPut = -1;
        boolean isGridChanged = false;
        int slots = inventory.getSlots() - 1;
        for (int i = 0; i < slots; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            ItemStack recipeStack = recipe.getStackInSlot(i);
            if (!slot.m_41619_() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.m_41619_() && slot.m_41613_() >= slot.m_41741_()) continue;
            if (slot.m_41619_()) {
                slotToPut = i;
                isGridChanged = true;
                break;
            }
            if (!stackToPut.m_41619_() && slot.m_41613_() >= stackToPut.m_41613_()) continue;
            slotToPut = i;
            stackToPut = slot;
        }
        this.isGridChanged |= isGridChanged;
        if (slotToPut > -1) {
            int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
            ItemStack toInsert = StackHelper.withSize((ItemStack)input, (int)1, (boolean)false);
            this.addStackToSlot(toInsert, slotToPut);
            this.getEnergy().extractEnergy(insertPowerRate, false);
            return true;
        }
        return false;
    }

    public static class WrappedRecipe {
        private final BiFunction<Container, RegistryAccess, ItemStack> resultFunc;
        private final BiFunction<Container, Level, Boolean> matchesFunc;
        private final BiFunction<CraftingContainer, Level, Boolean> matchesSavedRecipeFunc;
        private final Function<Container, NonNullList<ItemStack>> remainingItemsFunc;

        public WrappedRecipe(CraftingRecipe recipe, CraftingContainer craftingInventory) {
            this.resultFunc = (inventory, access) -> recipe.m_5874_((Container)craftingInventory, access);
            this.matchesFunc = (inventory, level) -> recipe.m_5818_((Container)craftingInventory, level);
            this.matchesSavedRecipeFunc = (arg_0, arg_1) -> ((CraftingRecipe)recipe).m_5818_(arg_0, arg_1);
            this.remainingItemsFunc = inventory -> recipe.m_7457_((Container)craftingInventory);
        }

        public WrappedRecipe(ITableRecipe recipe) {
            this.resultFunc = (arg_0, arg_1) -> ((ITableRecipe)recipe).m_5874_(arg_0, arg_1);
            this.matchesFunc = (arg_0, arg_1) -> ((ITableRecipe)recipe).m_5818_(arg_0, arg_1);
            this.matchesSavedRecipeFunc = (arg_0, arg_1) -> ((ITableRecipe)recipe).m_5818_(arg_0, arg_1);
            this.remainingItemsFunc = arg_0 -> ((ITableRecipe)recipe).m_7457_(arg_0);
        }

        public ItemStack getCraftingResult(Container inventory, RegistryAccess access) {
            return this.resultFunc.apply(inventory, access);
        }

        public boolean matches(Container inventory, Level level) {
            return this.matchesFunc.apply(inventory, level);
        }

        public boolean matchesSavedRecipe(BaseItemStackHandler inventory, Level level) {
            int size = (int)Math.sqrt(inventory.getSlots());
            return this.matchesSavedRecipeFunc.apply((CraftingContainer)new ExtendedCraftingInventory(EmptyContainer.INSTANCE, inventory, size), level);
        }

        public NonNullList<ItemStack> getRemainingItems(Container inventory) {
            return this.remainingItemsFunc.apply(inventory);
        }
    }

    public static class Basic
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Basic.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(10);

        public Basic(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.BASIC_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage(((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get()).intValue(), () -> ((Basic)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.basic_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return BasicAutoTableContainer.create(windowId, playerInventory, this.inventory, this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 20;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Basic.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            return BaseItemStackHandler.create((int)10, (Runnable)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{9});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }

    public static class Ultimate
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Ultimate.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(82);

        public Ultimate(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ULTIMATE_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 8, () -> ((Ultimate)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.ultimate_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return UltimateAutoTableContainer.create(windowId, playerInventory, this.inventory, this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 80;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Ultimate.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            return BaseItemStackHandler.create((int)82, (Runnable)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{81});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }

    public static class Elite
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Elite.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(50);

        public Elite(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ELITE_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 4, () -> ((Elite)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.elite_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return EliteAutoTableContainer.create(windowId, playerInventory, this.inventory, this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 60;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Elite.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            return BaseItemStackHandler.create((int)50, (Runnable)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{49});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }

    public static class Advanced
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Advanced.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(26);

        public Advanced(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ADVANCED_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 2, () -> ((Advanced)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.advanced_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return AdvancedAutoTableContainer.create(windowId, playerInventory, this.inventory, this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 40;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Advanced.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            return BaseItemStackHandler.create((int)26, (Runnable)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{25});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }
}

