/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.render.GhostItemRenderer;
import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.client.screen.button.RecipeSelectButton;
import com.blakebr0.extendedcrafting.container.AutoFluxCrafterContainer;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoFluxCrafterTileEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class AutoFluxCrafterScreen
extends BaseContainerScreen<AutoFluxCrafterContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/auto_flux_crafter.png");
    private AutoFluxCrafterTileEntity tile;

    public AutoFluxCrafterScreen(AutoFluxCrafterContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 176, 194);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((AutoFluxCrafterContainer)this.m_6262_()).getBlockPos();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 132, y + 7, pos, 0, 66, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 145, y + 7, pos, 1, 66, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 158, y + 7, pos, 2, 66, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.m_142416_((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        gfx.m_280056_(this.f_96547_, title, 32, 6, 0x404040, false);
        gfx.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 94, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        BaseItemStackHandler recipe;
        super.renderDefaultBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.getProgress() > 0) {
            int i2 = this.getProgressBarScaled();
            gfx.m_280218_(BACKGROUND, x + 92, y + 48, 194, 0, i2 + 1, 16);
        }
        if ((recipe = this.getSelectedRecipe()) != null) {
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    ItemStack item = recipe.getStackInSlot(index);
                    GhostItemRenderer.renderItemIntoGui((ItemStack)item, (int)(x + 33 + j * 18), (int)(y + 30 + i * 18), (ItemRenderer)itemRenderer);
                }
            }
            ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
            GhostItemRenderer.renderItemIntoGui((ItemStack)output, (int)(x + 127), (int)(y + 48), (ItemRenderer)itemRenderer);
        }
    }

    private void onSelectButtonTooltip(Button button, GuiGraphics gfx, int mouseX, int mouseY) {
        int index = ((RecipeSelectButton)button).getIndex();
        boolean isSelected = ((RecipeSelectButton)button).isSelected();
        BaseItemStackHandler recipe = this.getRecipeInfo(index);
        if (recipe != null) {
            ArrayList tooltip;
            boolean hasRecipe;
            boolean bl = hasRecipe = !recipe.getStacks().stream().allMatch(ItemStack::m_41619_);
            if (hasRecipe) {
                ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
                tooltip = Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)(output.m_41613_() + "x " + output.m_41786_().getString())), Component.m_237113_((String)""), ModTooltips.AUTO_TABLE_DELETE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(1, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                }
            } else {
                tooltip = Lists.newArrayList((Object[])new Component[]{ModTooltips.AUTO_TABLE_SAVE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(0, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                    tooltip.add(1, Component.m_237113_((String)""));
                }
            }
            gfx.m_280666_(this.f_96547_, (List)tooltip, mouseX, mouseY);
        }
    }

    private AutoFluxCrafterTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((AutoFluxCrafterContainer)this.m_6262_()).getBlockPos())) instanceof AutoFluxCrafterTileEntity) {
            AutoFluxCrafterTileEntity crafter = (AutoFluxCrafterTileEntity)tile;
            return crafter;
        }
        return null;
    }

    private BaseItemStackHandler getRecipeInfo(int selected) {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getRecipe(selected);
    }

    private BaseItemStackHandler getSelectedRecipe() {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getSelectedRecipe();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getProgressRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgressRequired();
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        int j = Math.max(this.getProgressRequired(), i);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }
}

