/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.BlockManaBattery;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityMechanicalManaPool;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.item.BlackLotusItem;
import vazkii.botania.common.item.BotaniaItems;

public class BlockEntityManaBattery
extends BotanicalTile {
    private static final int MANA_TRANSFER_RATE = 5000;
    private boolean slot1Locked;
    private boolean slot2Locked;
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)2).validator(stack -> !this.slot1Locked && stack.getCapability(BotaniaForgeCapabilities.MANA_ITEM).resolve().map(manaItem -> manaItem.getMana() < manaItem.getMaxMana() && manaItem.canReceiveManaFromPool((BlockEntity)this)).orElse(false) != false, new int[]{0}).validator(stack -> !this.slot2Locked && stack.getCapability(BotaniaForgeCapabilities.MANA_ITEM).resolve().map(manaItem -> manaItem.getMana() > 0 && manaItem.canExportManaToPool((BlockEntity)this)).orElse(false) != false, new int[]{1}).contentsChanged(() -> {
        this.m_6596_();
        this.setDispatchable();
    }).build();

    public BlockEntityManaBattery(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, LibXServerConfig.MaxManaCapacity.manaBattery);
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public int getCurrentMana() {
        return ((BlockManaBattery)this.m_58900_().m_60734_()).variant == BlockManaBattery.Variant.CREATIVE ? this.getMaxMana() / 2 : super.getCurrentMana();
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack minus = this.inventory.getStackInSlot(0);
            ItemStack plus = this.inventory.getStackInSlot(1);
            if (!minus.m_41619_()) {
                minus.getCapability(BotaniaForgeCapabilities.MANA_ITEM).ifPresent(manaItem -> {
                    if (manaItem.canReceiveManaFromPool((BlockEntity)this)) {
                        int maxManaValue = ((BlockManaBattery)this.m_58900_().m_60734_()).variant == BlockManaBattery.Variant.NORMAL ? 5000 : Integer.MAX_VALUE;
                        int manaValue = Math.min(maxManaValue, Math.min(this.getCurrentMana(), manaItem.getMaxMana() - manaItem.getMana()));
                        manaItem.addMana(manaValue);
                        this.receiveMana(-manaValue);
                        this.m_6596_();
                        this.setDispatchable();
                    }
                });
            }
            if (!plus.m_41619_()) {
                plus.getCapability(BotaniaForgeCapabilities.MANA_ITEM).ifPresent(manaItem -> {
                    if (manaItem.canExportManaToPool((BlockEntity)this)) {
                        int maxManaValue = ((BlockManaBattery)this.m_58900_().m_60734_()).variant == BlockManaBattery.Variant.NORMAL ? 5000 : Integer.MAX_VALUE;
                        int manaValue = Math.min(maxManaValue, Math.min(this.getMaxMana() - this.getCurrentMana(), manaItem.getMana()));
                        manaItem.addMana(-manaValue);
                        this.receiveMana(manaValue);
                        this.m_6596_();
                        this.setDispatchable();
                    }
                });
                if (plus.m_41720_() instanceof BlackLotusItem) {
                    int manaToTransfer;
                    int n = manaToTransfer = plus.m_41720_() == BotaniaItems.blackerLotus ? 100000 : 8000;
                    if (this.getAvailableSpaceForMana() >= manaToTransfer) {
                        this.receiveMana(manaToTransfer);
                        ItemStack stack = this.inventory.getStackInSlot(1).m_41777_();
                        stack.m_41774_(1);
                        this.inventory.setStackInSlot(1, stack);
                        this.m_6596_();
                        this.setDispatchable();
                    }
                }
            }
            for (Direction direction : Direction.values()) {
                BotanicalTile offsetTile;
                BlockEntity tile = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
                if (!(tile instanceof BotanicalTile) || !(offsetTile = (BotanicalTile)tile).actAsMana() || ((BlockManaBattery)this.m_58900_().m_60734_()).variant != BlockManaBattery.Variant.CREATIVE && tile instanceof BlockEntityManaBattery || offsetTile.isFull()) continue;
                int maxManaValue = ((BlockManaBattery)this.m_58900_().m_60734_()).variant == BlockManaBattery.Variant.NORMAL ? 5000 : Integer.MAX_VALUE;
                int manaValue = Math.min(maxManaValue, Math.min(this.getCurrentMana(), offsetTile.getMaxMana() - offsetTile.getCurrentMana()));
                if (manaValue <= 0 && offsetTile instanceof BlockEntityMechanicalManaPool) {
                    manaValue = Math.min(this.getCurrentMana(), 5000);
                }
                this.receiveMana(-manaValue);
                offsetTile.receiveMana(manaValue);
                this.m_6596_();
                this.setDispatchable();
            }
        }
    }

    public boolean isSlot1Locked() {
        return this.slot1Locked;
    }

    public boolean isSlot2Locked() {
        return this.slot2Locked;
    }

    public void setSlot1Locked(boolean slot1Locked) {
        if (slot1Locked != this.slot1Locked) {
            this.slot1Locked = slot1Locked;
            this.m_6596_();
        }
    }

    public void setSlot2Locked(boolean slot2Locked) {
        if (slot2Locked != this.slot2Locked) {
            this.slot2Locked = slot2Locked;
            this.m_6596_();
        }
    }

    @Override
    public int getComparatorOutput() {
        return (int)Math.round((double)this.getCurrentMana() / (double)this.getMaxMana() * 15.0);
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> {
            ItemStack minus = ((IItemHandlerModifiable)inventory.get()).getStackInSlot(0);
            ItemStack plus = ((IItemHandlerModifiable)inventory.get()).getStackInSlot(1);
            if (slot == 0) {
                Optional manaItem = minus.getCapability(BotaniaForgeCapabilities.MANA_ITEM).resolve();
                return manaItem.map(item -> item.getMana() >= item.getMaxMana()).orElse(true);
            }
            if (slot == 1 && plus.m_41720_() instanceof ManaItem) {
                Optional manaItem = plus.getCapability(BotaniaForgeCapabilities.MANA_ITEM).resolve();
                return manaItem.map(item -> item.getMana() <= 0).orElse(true);
            }
            return true;
        };
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.slot1Locked = nbt.m_128471_("slot1Locked");
        this.slot2Locked = nbt.m_128471_("slot2Locked");
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("slot1Locked", this.slot1Locked);
        nbt.m_128379_("slot2Locked", this.slot2Locked);
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        this.slot1Locked = nbt.m_128471_("slot1Locked");
        this.slot2Locked = nbt.m_128471_("slot2Locked");
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("slot1Locked", this.slot1Locked);
        nbt.m_128379_("slot2Locked", this.slot2Locked);
        return nbt;
    }
}

