/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.base;

import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.gui.ManaBar;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.moddingx.libx.menu.BlockEntityMenu;

public abstract class ScreenBase<X extends BlockEntityMenu<?>>
extends AbstractContainerScreen<X> {
    public final ManaBar manaBar;
    public int relX;
    public int relY;

    public ScreenBase(X menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        BlockEntity blockEntity = ((BlockEntityMenu)this.f_97732_).getBlockEntity();
        if (blockEntity instanceof BotanicalTile) {
            BotanicalTile botanicalTile = (BotanicalTile)blockEntity;
            this.manaBar = new ManaBar((Screen)this, botanicalTile.getMaxMana());
        } else {
            this.manaBar = new ManaBar((Screen)this, 0);
        }
    }

    public void m_6575_(@Nonnull Minecraft minecraft, int width, int height) {
        super.m_6575_(minecraft, width, height);
        this.relX = (width - this.f_97726_) / 2;
        this.relY = (height - this.f_97727_) / 2;
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.manaBar.guiTop = this.f_97736_;
        this.manaBar.guiLeft = this.f_97735_;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        BlockEntity blockEntity = ((BlockEntityMenu)this.f_97732_).getBlockEntity();
        if (blockEntity instanceof BotanicalTile) {
            BotanicalTile botanicalTile = (BotanicalTile)blockEntity;
            this.manaBar.renderHoveredToolTip(guiGraphics, mouseX, mouseY, botanicalTile.getCurrentMana());
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String s = this.f_96539_.getString();
        guiGraphics.drawString(this.f_96547_, s, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(s) / 2), 6.0f, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.f_96547_, this.f_169604_.getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), Color.DARK_GRAY.getRGB(), false);
    }

    public void drawDefaultGuiBackgroundLayer(GuiGraphics guiGraphics, ResourceLocation screenLocation) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(screenLocation, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        BlockEntity blockEntity = ((BlockEntityMenu)this.f_97732_).getBlockEntity();
        if (blockEntity instanceof BotanicalTile) {
            BotanicalTile botanicalTile = (BotanicalTile)blockEntity;
            this.manaBar.draw(guiGraphics, botanicalTile.getCurrentMana());
        }
    }
}

