/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles;

import com.google.common.base.Predicates;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.blocks.BlockManaTesseract;
import org.zeith.botanicadds.init.TilesBA;
import org.zeith.botanicadds.world.WorldTesseractData;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyInt;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.item.BotaniaItems;

public class TileManaTesseract
extends TileSyncableTickable
implements Wandable,
ManaReceiver,
SparkAttachable,
ManaPool {
    @NBTSerializable(value="mana")
    public int _mana;
    @NBTSerializable(value="max_mana")
    public int _maxMana = 100;
    @NBTSerializable(value="channel")
    public String channelReadable;
    @NBTSerializable(value="owner_name")
    public String channelOwnerName;
    @NBTSerializable(value="private")
    public boolean isPrivate;
    public GameProfile owner;
    public final PropertyInt maxManaData = new PropertyInt(DirectStorage.create(v -> {
        this._maxMana = v;
    }, () -> this._maxMana));
    public final PropertyInt manaData = new PropertyInt(DirectStorage.create(v -> {
        this._mana = v;
    }, () -> this._mana));
    LazyOptional<Wandable> wandableCap = LazyOptional.of(() -> this);
    LazyOptional<ManaReceiver> manaReceiverCap = LazyOptional.of(() -> this);
    LazyOptional<SparkAttachable> sparkCap = LazyOptional.of(() -> this);

    public TileManaTesseract(BlockPos pos, BlockState state) {
        super(TilesBA.MANA_TESSERACT, pos, state);
        this.dispatcher.registerProperty("mana", (IProperty)this.manaData);
        this.dispatcher.registerProperty("max_mana", (IProperty)this.maxManaData);
    }

    public CompoundTag writeNBT(CompoundTag nbt) {
        nbt = super.writeNBT(nbt);
        if (this.owner != null) {
            nbt.m_128365_("OwnerGP", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.owner));
        }
        return nbt;
    }

    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128425_("OwnerGP", 10)) {
            this.owner = NbtUtils.m_129228_((CompoundTag)nbt.m_128469_("OwnerGP"));
        }
        super.readNBT(nbt);
    }

    public WorldTesseractData.TesseractMode getMode() {
        return (WorldTesseractData.TesseractMode)((Object)this.m_58900_().m_61143_(BlockManaTesseract.MODE));
    }

    public String getChannel() {
        if (this.isPrivate) {
            if (this.owner == null) {
                return null;
            }
            return "pri/" + this.owner.getId().toString() + "/" + this.channelReadable;
        }
        return "pub/" + this.channelReadable;
    }

    public boolean hasChannel() {
        return !StringUtil.m_14408_((String)this.getChannel());
    }

    public void update() {
        ServerPlayer sp;
        if (this.isOnClient() || this.f_58857_ == null) {
            return;
        }
        WorldTesseractData td = WorldTesseractData.forServer(this.f_58857_).orElse(null);
        if (td == null) {
            return;
        }
        WorldTesseractData.TesseractMode mode = this.getMode();
        String channel = this.getChannel();
        MinecraftServer srv = this.f_58857_.m_7654_();
        if (srv != null && this.owner != null && (sp = srv.m_6846_().m_11259_(this.owner.getId())) != null) {
            this.owner = sp.m_36316_();
            this.channelOwnerName = this.owner.getName();
        }
        if (this.hasChannel()) {
            this.manaData.setInt(td.getMana(channel));
            this.maxManaData.setInt(td.getMaxManaPerChannel(channel));
        } else {
            this.manaData.setInt(0);
            this.maxManaData.setInt(1000000);
            this.f_58857_.m_46961_(this.f_58858_, true);
        }
        if (this.atTickRate(3) && mode.shouldEmitMana()) {
            for (Direction dir : Direction.values()) {
                ManaReceiver manaRec;
                BlockEntity remoteBE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
                if (remoteBE == null || remoteBE instanceof TileManaTesseract || (manaRec = (ManaReceiver)remoteBE.getCapability(BotaniaForgeCapabilities.MANA_RECEIVER, dir.m_122424_()).orElse(null)) == null || manaRec.isFull()) continue;
                int take = td.takeMana(channel, 1000, IFluidHandler.FluidAction.EXECUTE);
                manaRec.receiveMana(take);
            }
        }
    }

    public ItemStack storeData(ItemStack base) {
        if (this.channelReadable != null && !this.channelReadable.isBlank()) {
            base.m_41784_().m_128359_("Channel", this.channelReadable);
        }
        base.m_41784_().m_128379_("Private", this.isPrivate);
        return base;
    }

    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player != null && player.m_6144_()) {
            WorldTesseractData.TesseractMode mode = (WorldTesseractData.TesseractMode)((Object)this.m_58900_().m_61143_(BlockManaTesseract.MODE));
            WorldTesseractData.TesseractMode[] modes = WorldTesseractData.TesseractMode.values();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(BlockManaTesseract.MODE, (Comparable)((Object)modes[(mode.ordinal() + 1) % modes.length])));
        }
        return true;
    }

    public Level getManaReceiverLevel() {
        return this.f_58857_;
    }

    public BlockPos getManaReceiverPos() {
        return this.f_58858_;
    }

    public int getCurrentMana() {
        return this._mana;
    }

    public int getMaxMana() {
        return this._maxMana;
    }

    public boolean isFull() {
        return !this.hasChannel() || !this.getMode().shouldAcceptMana() || this.getCurrentMana() >= this.getMaxMana();
    }

    public void receiveMana(int mana) {
        if (!this.hasChannel() || !this.isOnServer()) {
            return;
        }
        String channel = this.getChannel();
        if (mana < 0) {
            WorldTesseractData.forServer(this.f_58857_).ifPresent(data -> {
                data.takeMana(channel, -mana, IFluidHandler.FluidAction.EXECUTE);
                this.manaData.setInt(data.getMana(channel));
            });
        } else if (mana > 0) {
            WorldTesseractData.forServer(this.f_58857_).ifPresent(data -> {
                data.storeMana(channel, mana, IFluidHandler.FluidAction.EXECUTE);
                this.manaData.setInt(data.getMana(channel));
            });
        }
    }

    public boolean canReceiveManaFromBursts() {
        return this.isOnServer() && this.getMode().shouldAcceptMana();
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return this.getMode().shouldAcceptMana() ? this.getMaxMana() - this.getCurrentMana() : 0;
    }

    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            return (ManaSpark)Cast.cast(sparks.get(0));
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.isFull();
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (BotaniaForgeCapabilities.WANDABLE == cap) {
            return BotaniaForgeCapabilities.WANDABLE.orEmpty(cap, this.wandableCap);
        }
        if (BotaniaForgeCapabilities.MANA_RECEIVER == cap) {
            return BotaniaForgeCapabilities.MANA_RECEIVER.orEmpty(cap, this.manaReceiverCap);
        }
        if (BotaniaForgeCapabilities.SPARK_ATTACHABLE == cap) {
            return BotaniaForgeCapabilities.SPARK_ATTACHABLE.orEmpty(cap, this.sparkCap);
        }
        return super.getCapability(cap, side);
    }

    public static class WandHud
    implements WandHUD {
        private final TileManaTesseract tess;

        public WandHud(TileManaTesseract tess) {
            this.tess = tess;
        }

        public void renderHUD(GuiGraphics gfx, Minecraft mc) {
            ItemStack tess = new ItemStack((ItemLike)this.tess.m_58900_().m_60734_());
            String name = tess.m_41786_().getString();
            float saturation = (float)(Math.sin(Math.toRadians((double)(System.currentTimeMillis() % 3600L) / 10.0)) + 1.0) / 2.0f * 0.25f;
            BotaniaAPIClient.instance().drawSimpleManaHUD(gfx, Mth.m_14169_((float)0.5361111f, (float)(0.5f + saturation), (float)1.0f), this.tess.getCurrentMana(), this.tess.getMaxMana(), name);
            int x = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - 11;
            int y = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + 30;
            int u = this.tess.getMode().shouldEmitMana() ? 22 : 0;
            int v = 38;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderHelper.drawTexturedModalRect((GuiGraphics)gfx, (ResourceLocation)HUDHandler.manaBar, (int)x, (int)y, (int)u, (int)v, (int)22, (int)15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gfx.m_280480_(new ItemStack((ItemLike)BotaniaItems.spark), x - 20, y);
            gfx.m_280480_(tess, x + 26, y);
            int modeColor = 0x22AA22;
            String mode = "public";
            if (this.tess.isPrivate) {
                modeColor = 0xAA2222;
                mode = "private";
            }
            MutableComponent modeCom = Component.m_237115_((String)("info.botanicadds.tesseract_attuner.mode." + mode));
            if (this.tess.isPrivate && !StringUtil.m_14408_((String)this.tess.channelOwnerName)) {
                modeCom = modeCom.m_130946_(" (").m_130946_(this.tess.channelOwnerName).m_130946_(")");
            }
            MutableComponent comp = Component.m_237110_((String)"info.botanicadds.tesseract_attuner.mode", (Object[])new Object[]{modeCom.m_130948_(Style.f_131099_.m_178520_(modeColor))});
            x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92852_((FormattedText)comp) / 2;
            gfx.m_280430_(mc.f_91062_, (Component)comp, x, y += 20, 42347);
            MutableComponent comp2 = Component.m_237113_((String)this.tess.channelReadable);
            Objects.requireNonNull(mc.f_91062_);
            x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92852_((FormattedText)comp2) / 2;
            gfx.m_280430_(mc.f_91062_, (Component)comp2, x, y += 9 + 2, 42347);
        }
    }
}

