/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.items;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.impl.mana.ManaItemHandlerImpl;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;
import vazkii.botania.common.lib.BotaniaTags;

public class ItemManaStealerSword
extends ManasteelSwordItem
implements LensEffectItem,
IRegisterListener {
    public static final Tier MANA_STEALING = new ForgeTier(0, 3000, 1.0f, 11.0f, 60, BlockTags.f_144285_, () -> Ingredient.m_204132_((TagKey)BotaniaTags.Items.INGOTS_TERRASTEEL));
    private static final String TAG_OWNER = "Owner";
    private static final String TAG_OWNER_ID = "Id";
    private static final int MANA_PER_DAMAGE = 200;

    public ItemManaStealerSword(Item.Properties props) {
        super(MANA_STEALING, 0, 0.0f, props);
    }

    public void onPostRegistered() {
        MinecraftForge.EVENT_BUS.addListener(this::attackEntity);
    }

    private void attackEntity(AttackEntityEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.trySpawnBurst(sp);
        }
    }

    public void trySpawnBurst(ServerPlayer player) {
        if (player.m_21205_().m_150930_((Item)this) && player.m_36403_(0.0f) == 1.0f) {
            ManaBurst burst = this.getBurst(player, player.m_21205_());
            player.m_9236_().m_7967_((Entity)burst.entity());
            player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.terraBlade, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public ManaBurst getBurst(ServerPlayer player, ItemStack stack) {
        ManaBurstEntity burst = new ManaBurstEntity((Player)player);
        float motionModifier = 7.0f;
        burst.setColor(10499383);
        burst.setMana(200);
        burst.setStartingMana(200);
        burst.setMinManaLoss(50);
        burst.setManaLossPerTick(1.0f);
        burst.setGravity(0.0f);
        burst.m_20256_(burst.m_20184_().m_82490_((double)motionModifier));
        ItemStack lens = stack.m_41777_();
        lens.m_41698_(TAG_OWNER).m_128362_(TAG_OWNER_ID, player.m_20148_());
        burst.setSourceLens(lens);
        return burst;
    }

    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        EntityHitResult er;
        Entity entity;
        int cost = 2000 + (int)Math.round(Math.random() * 2000.0);
        if (!shouldKill && pos instanceof EntityHitResult && (entity = (er = (EntityHitResult)pos).m_82443_()) instanceof ManaSpark) {
            ManaSpark spark = (ManaSpark)entity;
            Entity victim = (Entity)spark;
            UUID attacker = burst.getSourceLens().m_41698_(TAG_OWNER).m_128342_(TAG_OWNER_ID);
            Player owner2 = burst.entity().m_9236_().m_46003_(attacker);
            if (owner2 == null) {
                return false;
            }
            int manaToPut = Math.min(spark.getAttachedManaReceiver().getCurrentMana(), cost);
            spark.getAttachedManaReceiver().receiveMana(-manaToPut);
            ManaItemHandlerImpl.INSTANCE.dispatchMana(stack, owner2, manaToPut, true);
            owner2.m_9236_().m_6263_(null, victim.m_20182_().f_82479_, victim.m_20182_().f_82480_, victim.m_20182_().f_82481_, BotaniaSounds.enchanterFade, SoundSource.PLAYERS, 0.4f, 1.4f);
            owner2.m_9236_().m_6263_(null, owner2.m_20182_().f_82479_, owner2.m_20182_().f_82480_, owner2.m_20182_().f_82481_, BotaniaSounds.enchanterForm, SoundSource.PLAYERS, 0.4f, 1.4f);
            return true;
        }
        if (pos != null && pos.m_6662_() == HitResult.Type.ENTITY && pos instanceof EntityHitResult) {
            er = (EntityHitResult)pos;
            if (shouldKill) {
                UUID attacker = burst.getSourceLens().m_41698_(TAG_OWNER).m_128342_(TAG_OWNER_ID);
                Player owner = burst.entity().m_9236_().m_46003_(attacker);
                if (owner == null) {
                    return true;
                }
                Entity owner2 = er.m_82443_();
                if (owner2 instanceof Player) {
                    Player victim = (Player)owner2;
                    int extracted = ManaItemHandlerImpl.INSTANCE.requestMana(stack, victim, cost, false);
                    ManaItemHandlerImpl.INSTANCE.requestMana(stack, victim, ManaItemHandlerImpl.INSTANCE.dispatchMana(stack, owner, extracted, true), true);
                    victim.m_9236_().m_6263_(null, victim.m_20182_().f_82479_, victim.m_20182_().f_82480_, victim.m_20182_().f_82481_, BotaniaSounds.enchanterFade, SoundSource.PLAYERS, 0.4f, 1.4f);
                }
                owner.m_9236_().m_6263_(null, owner.m_20182_().f_82479_, owner.m_20182_().f_82480_, owner.m_20182_().f_82481_, BotaniaSounds.enchanterForm, SoundSource.PLAYERS, 0.4f, 1.4f);
            }
        }
        return shouldKill;
    }

    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        AABB axis = new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82400_(1.0);
        List entities = entity.m_9236_().m_45976_(LivingEntity.class, axis);
        Entity thrower = entity.m_19749_();
        for (LivingEntity living : entities) {
            if (living == thrower) continue;
            if (living instanceof Player) {
                Player throwingPlayer;
                Player livingPlayer = (Player)living;
                if (thrower instanceof Player && !(throwingPlayer = (Player)thrower).m_7099_(livingPlayer)) continue;
            }
            if (living.f_20916_ != 0) continue;
            int cost = 66;
            int mana = burst.getMana();
            if (mana < cost) continue;
            burst.setMana(mana - cost);
            float damage = 4.0f + BotaniaAPI.instance().getTerrasteelItemTier().m_6631_();
            if (burst.isFake() || entity.m_9236_().f_46443_) continue;
            DamageSource source = entity.m_9236_().m_269111_().m_269425_();
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                source = entity.m_9236_().m_269111_().m_269075_(player);
            } else if (thrower instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)thrower;
                source = entity.m_9236_().m_269111_().m_269333_(livingEntity);
            }
            living.m_6469_(source, damage);
            this.collideBurst(burst, (HitResult)new EntityHitResult((Entity)living), false, true, stack);
            entity.m_146870_();
            break;
        }
    }

    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        return true;
    }
}

