/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.api.tile.ICustomCapacityManaPool;
import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.block_entity.ManaPoolBlockEntityRenderer;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TESRCustomManaPool
implements BlockEntityRenderer<ManaPoolBlockEntity> {
    public TextureAtlasSprite getWaterSprite() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix((String)"block/mana_water"));
    }

    public void render(@Nullable ManaPoolBlockEntity pool, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float manaLevel;
        if (!(pool instanceof ICustomCapacityManaPool)) {
            return;
        }
        ICustomCapacityManaPool cp = (ICustomCapacityManaPool)pool;
        ms.m_85836_();
        int insideUVStart = cp.getPoolInset();
        int insideUVEnd = 16 - insideUVStart;
        float poolBottom = cp.getPoolBottom();
        float poolTop = (cp.getPoolTop() - 1.0f) / 16.0f;
        Block below = pool.m_58904_().m_8055_(pool.m_58899_().m_7495_()).m_60734_();
        if (below instanceof PoolOverlayProvider) {
            PoolOverlayProvider overlayProvider = (PoolOverlayProvider)below;
            ResourceLocation overlaySpriteId = overlayProvider.getIcon(pool.m_58904_(), pool.m_58899_());
            TextureAtlasSprite overlayIcon = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(overlaySpriteId);
            ms.m_85836_();
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2);
            ms.m_252880_(0.0f, poolBottom, 0.0f);
            ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.ICON_OVERLAY);
            RenderHelper.renderIconCropped((PoseStack)ms, (VertexConsumer)buffer, (int)insideUVStart, (int)insideUVStart, (int)insideUVEnd, (int)insideUVEnd, (TextureAtlasSprite)overlayIcon, (int)0xFFFFFF, (float)alpha, (int)light);
            ms.m_85849_();
        }
        int mana = pool == null ? ManaPoolBlockEntityRenderer.cartMana : pool.getCurrentMana();
        int maxMana = pool.getMaxMana();
        if (maxMana == -1) {
            maxMana = cp.getMaxCustomMana();
        }
        if ((manaLevel = (float)mana / (float)maxMana) > 0.0f) {
            ms.m_85836_();
            ms.m_252880_(0.0f, Mth.m_184631_((float)manaLevel, (float)0.0f, (float)1.0f, (float)poolBottom, (float)poolTop), 0.0f);
            ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.MANA_POOL_WATER);
            RenderHelper.renderIconCropped((PoseStack)ms, (VertexConsumer)buffer, (int)insideUVStart, (int)insideUVStart, (int)insideUVEnd, (int)insideUVEnd, (TextureAtlasSprite)this.getWaterSprite(), (int)0xFFFFFF, (float)1.0f, (int)light);
            ms.m_85849_();
        }
        ms.m_85849_();
        ManaPoolBlockEntityRenderer.cartMana = -1;
    }
}

