/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.zeith.hammerlib.core.adapter.TagAdapter;

public class BlockSculkSensorDisabled
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = BlockSculkSensorDisabled.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public BlockSculkSensorDisabled(BlockBehaviour.Properties props) {
        super(props.m_60977_());
        TagAdapter.bind((TagKey)BlockTags.f_144281_, (Object[])new Block[]{this});
    }

    public static int generateRegrowDelay(RandomSource rng) {
        return 6000 + rng.m_188503_(6000);
    }

    public boolean reduce(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_(Blocks.f_152500_)) {
            Boolean hasWater = (Boolean)state.m_61143_((Property)SculkSensorBlock.f_154388_);
            BlockState replaceState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)hasWater);
            level.m_46597_(pos, replaceState);
            level.m_186460_(pos, (Block)this, BlockSculkSensorDisabled.generateRegrowDelay(level.f_46441_));
            level.m_220407_(GameEvent.f_157781_, pos, new GameEvent.Context(null, state));
            return true;
        }
        return false;
    }

    public boolean regrow(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)this)) {
            Boolean hasWater = (Boolean)state.m_61143_((Property)WATERLOGGED);
            BlockState replaceState = (BlockState)Blocks.f_152500_.m_49966_().m_61124_((Property)SculkSensorBlock.f_154388_, (Comparable)hasWater);
            level.m_46597_(pos, replaceState);
            level.m_5594_(null, pos, SoundEvents.f_144217_, SoundSource.BLOCKS, 1.0f, 1.6f);
            return true;
        }
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        if (rng.m_188503_(5) == 0) {
            this.onTick(state, level, pos, rng, true);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        this.onTick(state, level, pos, rng, false);
    }

    public void onTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng, boolean wasRandom) {
        if (rng.m_188503_(15) == 0) {
            this.regrow((Level)level, pos);
        } else if (!wasRandom) {
            level.m_186460_(pos, state.m_60734_(), BlockSculkSensorDisabled.generateRegrowDelay(rng));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_154396_) {
        BlockPos blockpos = p_154396_.m_8083_();
        FluidState fluidstate = p_154396_.m_43725_().m_6425_(blockpos);
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState p_154457_, Direction p_154458_, BlockState p_154459_, LevelAccessor p_154460_, BlockPos p_154461_, BlockPos p_154462_) {
        if (((Boolean)p_154457_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_154460_.m_186469_(p_154461_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_154460_));
        }
        return super.m_7417_(p_154457_, p_154458_, p_154459_, p_154460_, p_154461_, p_154462_);
    }

    public VoxelShape m_5940_(BlockState p_154432_, BlockGetter p_154433_, BlockPos p_154434_, CollisionContext p_154435_) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_154464_) {
        p_154464_.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7357_(BlockState p_154427_, BlockGetter p_154428_, BlockPos p_154429_, PathComputationType p_154430_) {
        return false;
    }

    public boolean m_7923_(BlockState p_154486_) {
        return true;
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        return silkTouchLevel == 0 ? 5 : 0;
    }
}

