/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.earlydisplay;

import org.lwjgl.opengl.GL32C;

public class ElementShader {
    private int program;
    private int textureUniform;
    private int screenSizeUniform;
    private int renderTypeUniform;

    public void init() {
        int vertexShader = GL32C.glCreateShader((int)35633);
        int fragmentShader = GL32C.glCreateShader((int)35632);
        GL32C.glShaderSource((int)fragmentShader, (CharSequence)"         #version 150 core\n         uniform sampler2D tex;\n         uniform int rendertype;\n         in vec2 fTex;\n         in vec4 fColour;\n         out vec4 fragColor;\n\n         void main() {\n             if (rendertype == 0)\n                    fragColor = vec4(1,1,1,texture(tex, fTex).r) * fColour;\n             if (rendertype == 1)\n                    fragColor = texture(tex, fTex) * fColour;\n             if (rendertype == 2)\n                    fragColor = fColour;\n         }\n");
        GL32C.glShaderSource((int)vertexShader, (CharSequence)"         #version 150 core\n         in vec2 position;\n         in vec2 tex;\n         in vec4 colour;\n         uniform vec2 screenSize;\n         out vec2 fTex;\n         out vec4 fColour;\n         void main() {\n             fTex = tex;\n             fColour = colour;\n             gl_Position = vec4((position/screenSize) * 2 - 1, 0.0, 1.0);\n         }\n");
        GL32C.glCompileShader((int)vertexShader);
        if (GL32C.glGetShaderi((int)vertexShader, (int)35713) == 0) {
            throw new IllegalStateException("VertexShader linkage failure. \n" + GL32C.glGetShaderInfoLog((int)vertexShader));
        }
        GL32C.glCompileShader((int)fragmentShader);
        if (GL32C.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
            throw new IllegalStateException("FragmentShader linkage failure. \n" + GL32C.glGetShaderInfoLog((int)fragmentShader));
        }
        int program = GL32C.glCreateProgram();
        GL32C.glBindAttribLocation((int)program, (int)0, (CharSequence)"position");
        GL32C.glBindAttribLocation((int)program, (int)1, (CharSequence)"tex");
        GL32C.glBindAttribLocation((int)program, (int)2, (CharSequence)"colour");
        GL32C.glAttachShader((int)program, (int)vertexShader);
        GL32C.glAttachShader((int)program, (int)fragmentShader);
        GL32C.glLinkProgram((int)program);
        if (GL32C.glGetProgrami((int)program, (int)35714) == 0) {
            throw new RuntimeException("ShaderProgram linkage failure. \n" + GL32C.glGetProgramInfoLog((int)program));
        }
        this.program = program;
        GL32C.glDetachShader((int)program, (int)vertexShader);
        GL32C.glDetachShader((int)program, (int)fragmentShader);
        GL32C.glDeleteShader((int)vertexShader);
        GL32C.glDeleteShader((int)fragmentShader);
        this.textureUniform = GL32C.glGetUniformLocation((int)program, (CharSequence)"tex");
        this.screenSizeUniform = GL32C.glGetUniformLocation((int)program, (CharSequence)"screenSize");
        this.renderTypeUniform = GL32C.glGetUniformLocation((int)program, (CharSequence)"rendertype");
        this.activate();
    }

    public void activate() {
        GL32C.glUseProgram((int)this.program);
    }

    public void updateTextureUniform(int textureNumber) {
        GL32C.glUniform1i((int)this.textureUniform, (int)textureNumber);
    }

    public void updateScreenSizeUniform(int width, int height) {
        GL32C.glUniform2f((int)this.screenSizeUniform, (float)width, (float)height);
    }

    public void updateRenderTypeUniform(RenderType type) {
        GL32C.glUniform1i((int)this.renderTypeUniform, (int)type.ordinal());
    }

    public void clear() {
        GL32C.glUseProgram((int)0);
    }

    public void close() {
        GL32C.glDeleteProgram((int)this.program);
    }

    public int program() {
        return this.program;
    }

    public static enum RenderType {
        FONT,
        TEXTURE,
        BAR;

    }
}

