/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.telemetry.TelemetryProperty;
import net.minecraft.client.telemetry.events.GameLoadTimesEvent;
import net.minecraft.core.UUIDUtil;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class Main {
    static final Logger f_129630_ = LogUtils.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] p_129642_) {
        Thread $$74;
        void $$72;
        Stopwatch $$1 = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
        Stopwatch $$2 = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
        GameLoadTimesEvent.f_285635_.m_285977_(TelemetryProperty.f_285605_, $$1);
        GameLoadTimesEvent.f_285635_.m_285977_(TelemetryProperty.f_285649_, $$2);
        SharedConstants.m_142977_();
        SharedConstants.m_214358_();
        OptionParser $$3 = new OptionParser();
        $$3.allowsUnrecognizedOptions();
        $$3.accepts("demo");
        $$3.accepts("disableMultiplayer");
        $$3.accepts("disableChat");
        $$3.accepts("fullscreen");
        $$3.accepts("checkGlErrors");
        OptionSpecBuilder $$4 = $$3.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$5 = $$3.accepts("quickPlayPath").withRequiredArg();
        ArgumentAcceptingOptionSpec $$6 = $$3.accepts("quickPlaySingleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$7 = $$3.accepts("quickPlayMultiplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$8 = $$3.accepts("quickPlayRealms").withRequiredArg();
        ArgumentAcceptingOptionSpec $$9 = $$3.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec $$10 = $$3.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec $$11 = $$3.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec $$12 = $$3.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$3.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec $$14 = $$3.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec $$15 = $$3.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec $$16 = $$3.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + Util.m_137550_() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$17 = $$3.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec $$18 = $$3.accepts("xuid").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$19 = $$3.accepts("clientId").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$20 = $$3.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec $$21 = $$3.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec $$22 = $$3.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$23 = $$3.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$24 = $$3.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec $$25 = $$3.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec $$26 = $$3.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$27 = $$3.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$28 = $$3.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec $$29 = $$3.accepts("userType").withRequiredArg().defaultsTo((Object)User.Type.LEGACY.m_193808_(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$30 = $$3.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec $$31 = $$3.nonOptions();
        OptionSet $$32 = $$3.parse(p_129642_);
        List $$33 = $$32.valuesOf((OptionSpec)$$31);
        if (!$$33.isEmpty()) {
            System.out.println("Completely ignored arguments: " + $$33);
        }
        String $$34 = (String)Main.m_129638_($$32, $$12);
        Proxy $$35 = Proxy.NO_PROXY;
        if ($$34 != null) {
            try {
                $$35 = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress($$34, (int)((Integer)Main.m_129638_($$32, $$13))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final String $$36 = (String)Main.m_129638_($$32, $$14);
        final String $$37 = (String)Main.m_129638_($$32, $$15);
        if (!$$35.equals(Proxy.NO_PROXY) && Main.m_129636_($$36) && Main.m_129636_($$37)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication($$36, $$37.toCharArray());
                }
            });
        }
        int $$38 = (Integer)Main.m_129638_($$32, $$22);
        int $$39 = (Integer)Main.m_129638_($$32, $$23);
        OptionalInt $$40 = Main.m_129634_((Integer)Main.m_129638_($$32, $$24));
        OptionalInt $$41 = Main.m_129634_((Integer)Main.m_129638_($$32, $$25));
        boolean $$42 = $$32.has("fullscreen");
        boolean $$43 = $$32.has("demo");
        boolean $$44 = $$32.has("disableMultiplayer");
        boolean $$45 = $$32.has("disableChat");
        String $$46 = (String)Main.m_129638_($$32, $$21);
        Gson $$47 = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        PropertyMap $$48 = GsonHelper.m_13794_($$47, (String)Main.m_129638_($$32, $$26), PropertyMap.class);
        PropertyMap $$49 = GsonHelper.m_13794_($$47, (String)Main.m_129638_($$32, $$27), PropertyMap.class);
        String $$50 = (String)Main.m_129638_($$32, $$30);
        File $$51 = (File)Main.m_129638_($$32, $$9);
        File $$52 = $$32.has((OptionSpec)$$10) ? (File)Main.m_129638_($$32, $$10) : new File($$51, "assets/");
        File $$53 = $$32.has((OptionSpec)$$11) ? (File)Main.m_129638_($$32, $$11) : new File($$51, "resourcepacks/");
        String $$54 = $$32.has((OptionSpec)$$17) ? (String)$$17.value($$32) : UUIDUtil.m_235879_((String)$$16.value($$32)).toString();
        String $$55 = $$32.has((OptionSpec)$$28) ? (String)$$28.value($$32) : null;
        String $$56 = (String)$$32.valueOf((OptionSpec)$$18);
        String $$57 = (String)$$32.valueOf((OptionSpec)$$19);
        String $$58 = (String)Main.m_129638_($$32, $$5);
        String $$59 = (String)Main.m_129638_($$32, $$6);
        String $$60 = (String)Main.m_129638_($$32, $$7);
        String $$61 = (String)Main.m_129638_($$32, $$8);
        if ($$32.has((OptionSpec)$$4)) {
            JvmProfiler.f_185340_.m_183425_(Environment.CLIENT);
        }
        CrashReport.m_127529_();
        Bootstrap.m_135870_();
        GameLoadTimesEvent.f_285635_.m_286069_(Bootstrap.f_285608_.get());
        Bootstrap.m_135889_();
        Util.m_137584_();
        String $$62 = (String)$$29.value($$32);
        User.Type $$63 = User.Type.m_92561_($$62);
        if ($$63 == null) {
            f_129630_.warn("Unrecognized user type: {}", (Object)$$62);
        }
        User $$64 = new User((String)$$16.value($$32), $$54, (String)$$20.value($$32), Main.m_195486_($$56), Main.m_195486_($$57), $$63);
        GameConfig $$65 = new GameConfig(new GameConfig.UserData($$64, $$48, $$49, $$35), new DisplayData($$38, $$39, $$40, $$41, $$42), new GameConfig.FolderData($$51, $$53, $$52, $$55), new GameConfig.GameData($$43, $$46, $$50, $$44, $$45), new GameConfig.QuickPlayData($$58, $$59, $$60, $$61));
        Thread $$66 = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                Minecraft $$0 = Minecraft.m_91087_();
                if ($$0 == null) {
                    return;
                }
                IntegratedServer $$1 = $$0.m_91092_();
                if ($$1 != null) {
                    $$1.m_7570_(true);
                }
            }
        };
        $$66.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_129630_));
        Runtime.getRuntime().addShutdownHook($$66);
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            Minecraft $$67 = new Minecraft($$65);
            RenderSystem.finishInitialization();
        }
        catch (SilentInitException $$68) {
            f_129630_.warn("Failed to create window: ", (Throwable)$$68);
            return;
        }
        catch (Throwable $$69) {
            CrashReport $$70 = CrashReport.m_127521_($$69, "Initializing game");
            CrashReportCategory $$71 = $$70.m_127514_("Initialization");
            NativeModuleLister.m_184679_($$71);
            Minecraft.m_167872_(null, null, $$65.f_101908_.f_101927_, null, $$70);
            Minecraft.m_91332_($$70);
            return;
        }
        if ($$72.m_91267_()) {
            Thread $$73 = new Thread("Game thread", (Minecraft)$$72){
                final /* synthetic */ Minecraft f_129652_;
                {
                    this.f_129652_ = minecraft;
                    super(p_129654_);
                }

                @Override
                public void run() {
                    try {
                        RenderSystem.initGameThread(true);
                        this.f_129652_.m_91374_();
                    }
                    catch (Throwable $$0) {
                        f_129630_.error("Exception in client thread", $$0);
                    }
                }
            };
            $$73.start();
            while ($$72.m_91396_()) {
            }
        } else {
            $$74 = null;
            try {
                RenderSystem.initGameThread(false);
                $$72.m_91374_();
            }
            catch (Throwable $$75) {
                f_129630_.error("Unhandled game exception", $$75);
            }
        }
        BufferUploader.m_166835_();
        try {
            $$72.m_91395_();
            if ($$74 != null) {
                $$74.join();
            }
        }
        catch (InterruptedException $$76) {
            f_129630_.error("Exception during client thread shutdown", (Throwable)$$76);
        }
        finally {
            $$72.m_91393_();
        }
    }

    private static Optional<String> m_195486_(String p_195487_) {
        return p_195487_.isEmpty() ? Optional.empty() : Optional.of(p_195487_);
    }

    private static OptionalInt m_129634_(@Nullable Integer p_129635_) {
        return p_129635_ != null ? OptionalInt.of(p_129635_) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T m_129638_(OptionSet p_129639_, OptionSpec<T> p_129640_) {
        try {
            return (T)p_129639_.valueOf(p_129640_);
        }
        catch (Throwable $$2) {
            ArgumentAcceptingOptionSpec $$3;
            List $$4;
            if (p_129640_ instanceof ArgumentAcceptingOptionSpec && !($$4 = ($$3 = (ArgumentAcceptingOptionSpec)p_129640_).defaultValues()).isEmpty()) {
                return (T)$$4.get(0);
            }
            throw $$2;
        }
    }

    private static boolean m_129636_(@Nullable String p_129637_) {
        return p_129637_ != null && !p_129637_.isEmpty();
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

