/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import reliquary.common.gui.AlkahestTomeMenu;
import reliquary.crafting.AlkahestryChargingRecipe;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModSounds;
import reliquary.item.ToggleableItem;
import reliquary.reference.Settings;
import reliquary.util.NBTHelper;
import reliquary.util.TooltipBuilder;

public class AlkahestryTomeItem
extends ToggleableItem {
    public AlkahestryTomeItem() {
        super(new Item.Properties().setNoRepair().m_41497_(Rarity.EPIC).m_41487_(1), (Supplier<Boolean>)Settings.COMMON.disable.disableAlkahestry);
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return AlkahestryTomeItem.getChargeLimit() + 1;
    }

    public int getDamage(ItemStack stack) {
        return this.getMaxDamage(stack) - AlkahestryTomeItem.getCharge(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ != EnchantmentCategory.BREAKABLE && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack newStack = (ItemStack)super.m_7203_(world, player, hand).m_19095_();
        if (player.m_6144_()) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)newStack);
        }
        player.m_5496_((SoundEvent)ModSounds.BOOK.get(), 1.0f, 1.0f);
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new AlkahestTomeMenu(w), stack.m_41786_()));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_6883_(ItemStack tome, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || world.m_46467_() % 10L != 0L || !this.isEnabled(tome) || AlkahestryTomeItem.getCharge(tome) == AlkahestryTomeItem.getChargeLimit()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        for (AlkahestryChargingRecipe recipe : AlkahestryRecipeRegistry.getChargingRecipes()) {
            this.consumeAndCharge(player, AlkahestryTomeItem.getChargeLimit() - AlkahestryTomeItem.getCharge(tome), recipe.getChargeToAdd(), (ItemStack ist) -> recipe.getChargingIngredient().test(ist), 16, (int chargeToAdd) -> AlkahestryTomeItem.addCharge(tome, chargeToAdd));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack tome, @Nullable Level level, TooltipBuilder tooltipBuilder) {
        if (level == null) {
            return;
        }
        tooltipBuilder.charge((Item)this, ".tooltip2", AlkahestryTomeItem.getCharge(tome), AlkahestryTomeItem.getChargeLimit());
        tooltipBuilder.description(this, ".tooltip3", new Object[0]);
        if (this.isEnabled(tome)) {
            tooltipBuilder.absorbActive(AlkahestryRecipeRegistry.getDrainRecipe().map(r -> r.m_8043_(level.m_9598_()).m_41786_().getString()).orElse(""));
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public static int getChargeLimit() {
        return (Integer)Settings.COMMON.items.alkahestryTome.chargeLimit.get();
    }

    public static ItemStack setCharge(ItemStack tome, int charge) {
        NBTHelper.putInt("charge", tome, charge);
        return tome;
    }

    public static int getCharge(ItemStack tome) {
        return NBTHelper.getInt("charge", tome);
    }

    public static void addCharge(ItemStack tome, int chageToAdd) {
        AlkahestryTomeItem.setCharge(tome, AlkahestryTomeItem.getCharge(tome) + chageToAdd);
    }

    public static void useCharge(ItemStack tome, int chargeToUse) {
        AlkahestryTomeItem.addCharge(tome, -chargeToUse);
    }
}

