/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.components;

import net.minecraft.client.gui.GuiGraphics;
import reliquary.client.gui.components.Component;

public class Box
extends Component {
    private final Layout layout;
    private final Alignment alignment;
    private final Component[] components;
    private int height;
    private int width;

    public Box(Layout layout, Alignment alignment, Component ... components) {
        this.layout = layout;
        this.alignment = alignment;
        this.components = components;
        this.updateDimensions();
    }

    private void updateDimensions() {
        int updatedHeight = 0;
        int updatedWidth = 0;
        for (Component component : this.components) {
            if (this.layout == Layout.HORIZONTAL) {
                updatedHeight = Math.max(updatedHeight, component.getHeight());
                updatedWidth += component.getWidth();
                continue;
            }
            updatedHeight += component.getHeight();
            updatedWidth = Math.max(updatedWidth, component.getWidth());
        }
        this.height = updatedHeight;
        this.width = updatedWidth;
    }

    public static Box createVertical(Component ... components) {
        return Box.createVertical(Alignment.TOP, components);
    }

    public static Box createVertical(Alignment alignment, Component ... components) {
        return new Box(Layout.VERTICAL, alignment, components);
    }

    public static Box createHorizontal(Component ... components) {
        return Box.createHorizontal(Alignment.LEFT, components);
    }

    public static Box createHorizontal(Alignment alignment, Component ... components) {
        return new Box(Layout.HORIZONTAL, alignment, components);
    }

    @Override
    public int getHeightInternal() {
        return this.height;
    }

    @Override
    public int getWidthInternal() {
        return this.width;
    }

    @Override
    public int getPadding() {
        return 0;
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        this.updateDimensions();
        for (Component component : this.components) {
            if (!component.shouldRender()) continue;
            int componentX = x;
            int componentY = y;
            switch (this.alignment) {
                case MIDDLE: {
                    componentX += this.layout == Layout.VERTICAL && component.getWidth() < this.width ? (this.width - component.getWidth()) / 2 : 0;
                    componentY += this.layout == Layout.HORIZONTAL && component.getHeight() < this.height ? (this.height - component.getHeight()) / 2 : 0;
                    break;
                }
                case RIGHT: {
                    componentX += this.layout == Layout.VERTICAL && component.getWidth() < this.width ? this.width - component.getWidth() : 0;
                    break;
                }
                case BOTTOM: {
                    componentY += this.layout == Layout.HORIZONTAL && component.getHeight() < this.height ? this.height - component.getHeight() : 0;
                }
            }
            component.render(guiGraphics, componentX, componentY);
            if (this.layout == Layout.HORIZONTAL) {
                x += component.getWidth();
                continue;
            }
            y += component.getHeight();
        }
    }

    public static enum Layout {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum Alignment {
        MIDDLE,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

