/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.iceandfire.client.model.ModelDreadBase;
import com.github.alexthe666.iceandfire.client.model.util.HideableModelRenderer;
import com.github.alexthe666.iceandfire.entity.EntityDreadKnight;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class ModelDreadKnight
extends ModelDreadBase<EntityDreadKnight> {
    public HideableModelRenderer chestplate;
    public HideableModelRenderer cloak;
    public HideableModelRenderer crown;
    public HideableModelRenderer sleeveRight;
    public HideableModelRenderer robeLowerRight;
    public HideableModelRenderer sleeveLeft;
    public HideableModelRenderer robeLowerLeft;

    public ModelDreadKnight(float modelScale) {
        this.texWidth = 128;
        this.texHeight = 64;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.sleeveRight = new HideableModelRenderer(this, 35, 33);
        this.sleeveRight.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveRight.addBox(-4.0f, -2.1f, -2.5f, 5.0f, 6.0f, 5.0f, modelScale);
        this.chestplate = new HideableModelRenderer(this, 1, 32);
        this.chestplate.setPos(0.0f, 0.1f, 0.0f);
        this.chestplate.addBox(-4.5f, 0.0f, -2.5f, 9.0f, 11.0f, 5.0f, modelScale);
        this.crown = new HideableModelRenderer(this, 58, -1);
        this.crown.setPos(0.0f, 0.0f, 0.0f);
        this.crown.addBox(-4.5f, -10.2f, -4.5f, 9.0f, 11.0f, 9.0f, modelScale);
        this.body = new HideableModelRenderer(this, 16, 16);
        this.body.setPos(0.0f, 0.0f, 0.0f);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelScale);
        this.legRight = new HideableModelRenderer(this, 0, 16);
        this.legRight.setPos(-1.9f, 12.0f, 0.1f);
        this.legRight.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.armLeft = new HideableModelRenderer(this, 40, 16);
        this.armLeft.mirror = true;
        this.armLeft.setPos(5.0f, 2.0f, -0.0f);
        this.armLeft.addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.setRotateAngle(this.armLeft, -0.0f, 0.10000736f, -0.10000736f);
        this.legLeft = new HideableModelRenderer(this, 0, 16);
        this.legLeft.mirror = true;
        this.legLeft.setPos(1.9f, 12.0f, 0.1f);
        this.legLeft.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.head = new HideableModelRenderer(this, 0, 0);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelScale);
        this.sleeveLeft = new HideableModelRenderer(this, 35, 33);
        this.sleeveLeft.mirror = true;
        this.sleeveLeft.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveLeft.addBox(-1.0f, -2.1f, -2.5f, 5.0f, 6.0f, 5.0f, modelScale);
        this.robeLowerRight = new HideableModelRenderer(this, 58, 33);
        this.robeLowerRight.mirror = true;
        this.robeLowerRight.setPos(0.0f, -0.2f, 0.0f);
        this.robeLowerRight.addBox(-2.1f, 0.0f, -2.5f, 4.0f, 7.0f, 5.0f, modelScale);
        this.cloak = new HideableModelRenderer(this, 81, 37);
        this.cloak.setPos(0.0f, 0.1f, 0.0f);
        this.cloak.addBox(-4.5f, 0.0f, 2.3f, 9.0f, 21.0f, 1.0f, modelScale);
        this.setRotateAngle(this.cloak, 0.045553092f, 0.0f, 0.0f);
        this.armRight = new HideableModelRenderer(this, 40, 16);
        this.armRight.setPos(-5.0f, 2.0f, 0.0f);
        this.armRight.addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelScale);
        this.setRotateAngle(this.armRight, -0.0f, -0.10000736f, 0.10000736f);
        this.robeLowerLeft = new HideableModelRenderer(this, 58, 33);
        this.robeLowerLeft.setPos(0.0f, -0.2f, 0.0f);
        this.robeLowerLeft.addBox(-1.9f, 0.0f, -2.5f, 4.0f, 7.0f, 5.0f, modelScale);
        this.armRight.addChild((BasicModelPart)this.sleeveRight);
        this.body.addChild((BasicModelPart)this.chestplate);
        this.head.addChild((BasicModelPart)this.crown);
        this.body.addChild((BasicModelPart)this.legRight);
        this.body.addChild((BasicModelPart)this.armLeft);
        this.body.addChild((BasicModelPart)this.legLeft);
        this.body.addChild((BasicModelPart)this.head);
        this.armLeft.addChild((BasicModelPart)this.sleeveLeft);
        this.legRight.addChild((BasicModelPart)this.robeLowerRight);
        this.body.addChild((BasicModelPart)this.cloak);
        this.body.addChild((BasicModelPart)this.armRight);
        this.legLeft.addChild((BasicModelPart)this.robeLowerLeft);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void prepareMobModel(EntityDreadKnight livingEntityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = livingEntityIn.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41720_() == Items.f_42411_ && livingEntityIn.f_20911_) {
            if (livingEntityIn.m_5737_() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.m_6839_((Entity)livingEntityIn, limbSwing, limbSwingAmount, partialTickTime);
    }

    @Override
    public void setRotationAnglesSpawn(EntityDreadKnight entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void animate(EntityDreadKnight entity, float f, float f1, float f2, float f3, float f4, float f5) {
    }

    @Override
    public Animation getSpawnAnimation() {
        return EntityDreadKnight.ANIMATION_SPAWN;
    }

    public void m_102624_(@NotNull EntityModel<EntityDreadKnight> p_217111_1_) {
        super.m_102624_(p_217111_1_);
        if (p_217111_1_ instanceof HumanoidModel) {
            HumanoidModel modelbiped = (HumanoidModel)p_217111_1_;
            modelbiped.f_102815_ = this.leftArmPose;
            modelbiped.f_102816_ = this.rightArmPose;
            modelbiped.f_102817_ = this.isSneak;
        }
    }
}

