/*
 * Decompiled with CFR 0.152.
 */
package com.azuriom.azauth.model;

import com.azuriom.azauth.model.Role;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class User {
    private final String username;
    private final UUID uuid;
    private final String accessToken;
    private final int id;
    private final String email;
    private final boolean emailVerified;
    private final double money;
    private final Role role;
    private final boolean banned;
    private final Instant createdAt;

    public User(int id, String username, UUID uuid, String accessToken, String email, boolean emailVerified, double money, Role role, boolean banned, Instant createdAt) {
        this.id = id;
        this.username = Objects.requireNonNull(username, "username");
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
        this.email = Objects.requireNonNull(email, "email");
        this.role = Objects.requireNonNull(role, "role");
        this.emailVerified = emailVerified;
        this.money = money;
        this.banned = banned;
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
    }

    public int getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public double getMoney() {
        return this.money;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean isBanned() {
        return this.banned;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.id == user.id && this.username.equals(user.username) && this.uuid.equals(user.uuid) && Objects.equals(this.accessToken, user.accessToken) && this.email.equals(user.email) && this.role.equals(user.role);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.username, this.uuid, this.accessToken, this.email, this.role);
    }

    public String toString() {
        return "User{id=" + this.id + ", username='" + this.username + "', uuid='" + this.uuid + "'}";
    }
}

