/*
 * Decompiled with CFR 0.152.
 */
package com.azuriom.azauth;

import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface AuthResult<T> {
    default public boolean isSuccess() {
        return this instanceof Success;
    }

    default public Success<T> asSuccess() {
        return (Success)this;
    }

    default public T getSuccessResult() {
        return this.asSuccess().getResult();
    }

    default public boolean isPending() {
        return this instanceof Pending;
    }

    default public Pending<T> asPending() {
        return (Pending)this;
    }

    default public Pending.Reason getPendingReason() {
        return this.asPending().getReason();
    }

    public static class Success<T>
    implements AuthResult<T> {
        private final T result;

        public Success(T result) {
            this.result = Objects.requireNonNull(result, "result");
        }

        public T getResult() {
            return this.result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Success success = (Success)o;
            return this.result.equals(success.result);
        }

        public int hashCode() {
            return this.result.hashCode();
        }

        public String toString() {
            return "Success{result=" + this.result + '}';
        }
    }

    public static class Pending<T>
    implements AuthResult<T> {
        private final Reason reason;

        public Pending(Reason reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
        }

        public Reason getReason() {
            return this.reason;
        }

        public boolean require2fa() {
            return this.reason == Reason.REQUIRE_2FA;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pending pending = (Pending)o;
            return this.reason == pending.reason;
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public String toString() {
            return "Pending{reason=" + (Object)((Object)this.reason) + '}';
        }

        public static enum Reason {
            REQUIRE_2FA;

        }
    }
}

