/*
 * Decompiled with CFR 0.152.
 */
package com.azuriom.azauth;

import com.azuriom.azauth.AuthResult;
import com.azuriom.azauth.exception.AuthException;
import com.azuriom.azauth.gson.ColorAdapter;
import com.azuriom.azauth.gson.InstantAdapter;
import com.azuriom.azauth.gson.UuidAdapter;
import com.azuriom.azauth.model.ErrorResponse;
import com.azuriom.azauth.model.User;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class AuthClient {
    private static final Logger LOGGER = Logger.getLogger(AuthClient.class.getName());
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Color.class, (Object)new ColorAdapter()).registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).registerTypeAdapter(UUID.class, (Object)new UuidAdapter()).create();
    private final String url;

    public AuthClient(String url) {
        Objects.requireNonNull(url, "url");
        String string = this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        if (!url.startsWith("https://")) {
            LOGGER.warning("HTTP links are not secure, use HTTPS instead.");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public AuthResult<User> login(String email, String password) throws AuthException {
        return this.login(email, password, User.class);
    }

    public AuthResult<User> login(String email, String password, @Nullable String code2fa) throws AuthException {
        return this.login(email, password, code2fa, User.class);
    }

    public <T> AuthResult<T> login(String email, String password, Class<T> responseType) throws AuthException {
        return this.login(email, password, (String)null, responseType);
    }

    public User login(String email, String password, Supplier<String> codeSupplier) throws AuthException {
        return this.login(email, password, codeSupplier, User.class);
    }

    public <T> T login(String email, String password, Supplier<@Nullable String> codeSupplier, Class<T> responseType) throws AuthException {
        AuthResult<T> result = this.login(email, password, responseType);
        if (result.isSuccess()) {
            return result.getSuccessResult();
        }
        if (!result.isPending() || !result.asPending().require2fa()) {
            throw new AuthException("Unknown login result: " + result);
        }
        String code = codeSupplier.get();
        if (code == null) {
            throw new AuthException("No 2FA code provided.");
        }
        result = this.login(email, password, code, responseType);
        if (!result.isSuccess()) {
            throw new AuthException("Unknown login result: " + result);
        }
        return result.getSuccessResult();
    }

    public <T> AuthResult<T> login(String email, String password, @Nullable String code2fa, Class<T> responseType) throws AuthException {
        JsonObject body = new JsonObject();
        body.addProperty("email", email);
        body.addProperty("password", password);
        body.addProperty("code", code2fa);
        return this.post("authenticate", body, responseType);
    }

    public User verify(String accessToken) throws AuthException {
        return this.verify(accessToken, User.class);
    }

    public <T> T verify(String accessToken, Class<T> responseType) throws AuthException {
        JsonObject body = new JsonObject();
        body.addProperty("access_token", accessToken);
        AuthResult<T> result = this.post("verify", body, responseType);
        if (!result.isSuccess()) {
            throw new AuthException("Unexpected verification result: " + result);
        }
        return result.asSuccess().getResult();
    }

    public void logout(String accessToken) throws AuthException {
        JsonObject body = new JsonObject();
        body.addProperty("access_token", accessToken);
        this.post("logout", body, JsonNull.class);
    }

    private <T> AuthResult<T> post(String endpoint, JsonObject body, Class<T> responseType) throws AuthException {
        try {
            URI api = URI.create(this.url + "/api/auth/" + endpoint);
            HttpURLConnection connection = (HttpURLConnection)api.toURL().openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.addRequestProperty("User-Agent", "AzAuth authenticator v1");
            try (OutputStream out = connection.getOutputStream();){
                out.write(body.toString().getBytes(StandardCharsets.UTF_8));
            }
            int status = connection.getResponseCode();
            if (status >= 400 && status < 500) {
                return this.handleClientError(connection);
            }
            return this.handleResponse(connection, responseType);
        }
        catch (IOException e) {
            throw new AuthException(e);
        }
    }

    private <T> AuthResult<T> handleResponse(HttpURLConnection connection, Class<@Nullable T> type) throws AuthException, IOException {
        if (type == JsonNull.class) {
            return new AuthResult.Success<T>(type.cast(JsonNull.INSTANCE));
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            Object response = GSON.fromJson((Reader)reader, type);
            if (response == null) {
                throw new AuthException("Empty JSON response from API");
            }
            AuthResult.Success<Object> success = new AuthResult.Success<Object>(response);
            return success;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> AuthResult<T> handleClientError(HttpURLConnection connection) throws AuthException, IOException {
        int status = connection.getResponseCode();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
            ErrorResponse response = (ErrorResponse)GSON.fromJson((Reader)reader, ErrorResponse.class);
            if (!response.getStatus().equals("pending")) throw new AuthException(response.getMessage());
            if (!Objects.equals(response.getReason(), "2fa")) throw new AuthException(response.getMessage());
            AuthResult.Pending pending = new AuthResult.Pending(AuthResult.Pending.Reason.REQUIRE_2FA);
            return pending;
        }
        catch (JsonParseException e) {
            throw new AuthException("Invalid JSON response from API (HTTP " + status + ")", e);
        }
    }
}

