/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.test;

import com.google.common.base.Supplier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.test.MainSchema;
import com.robertx22.test.ModSchema;
import com.robertx22.test.RegType;
import com.robertx22.test.SchemaReq;
import com.robertx22.test.SchemaSuggestions;
import com.robertx22.test.test2.SchemaTestMain;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SchemaPart<SELF, RAW, OBJECT> {
    public Supplier<SchemaPart<SELF, RAW, OBJECT>> sup;
    public String id;
    public ModSchema<?> holder;
    protected RAW object;
    public List<SchemaReq<RAW>> requirements = new ArrayList<SchemaReq<RAW>>();
    public SchemaSuggestions<RAW> suggestions = null;
    public RAW optionalValue = null;
    static String EMPTY_ID = "empty_id";
    public static ModSchema EMPTY_HOLDER = new EMPTY_HOLDER();

    public abstract RAW toRaw(OBJECT var1);

    public SchemaPart(ModSchema holder, String id, Supplier<SchemaPart<SELF, RAW, OBJECT>> sup) {
        this.id = id;
        this.holder = holder;
        this.sup = sup;
        if (!(holder instanceof EMPTY_HOLDER)) {
            holder.parts.add(this);
        }
    }

    public SELF setDefault(RAW val) {
        this.optionalValue = val;
        return (SELF)this;
    }

    public SELF getSelf() {
        return (SELF)this;
    }

    public SELF addReq(SchemaReq<RAW> req) {
        this.requirements.add(req);
        return this.getSelf();
    }

    public void setRaw(RAW raw) {
        this.object = raw;
    }

    public void set(OBJECT t) {
        this.object = this.toRaw(t);
    }

    public abstract OBJECT get();

    public RAW getRaw() {
        return this.object;
    }

    public boolean isOptional() {
        return this.optionalValue != null;
    }

    public void load(MainSchema main, JsonElement element) {
        RAW obj = this.fromJsonElement(main, element);
        this.object = obj;
        this.verify(main, SchemaReq.VerifyTime.ON_LOAD);
    }

    public void verify(MainSchema main, SchemaReq.VerifyTime time) {
        if (this.object == null && !this.isOptional()) {
            main.errorOut("Field " + this.id + " is null after loading");
        }
        for (SchemaReq<RAW> r : this.requirements) {
            if (r.verifyTime != time || r.pred.test(this.object)) continue;
            main.errorOut(r.errorMsg.apply(this.object));
        }
    }

    public abstract RAW fromJsonElement(MainSchema var1, JsonElement var2);

    public abstract void save(JsonObject var1);

    private static class EMPTY_HOLDER
    extends MainSchema<EMPTY_HOLDER> {
        public EMPTY_HOLDER() {
            super((Supplier<ModSchema>)((Supplier)() -> new SchemaTestMain()));
        }
    }

    public static class REGISTRY<T extends IGUID>
    extends SchemaPart<REGISTRY<T>, String, T> {
        RegType<T> type;

        public REGISTRY(ModSchema holder, final RegType<T> type, String id) {
            super(holder, id, () -> new REGISTRY(EMPTY_HOLDER, type, EMPTY_ID));
            this.type = type;
            this.addReq(REGISTRY.validRegistry(type));
            this.suggestions = new SchemaSuggestions<String>(){

                @Override
                public List<String> getAllPossible() {
                    return type.getAll().stream().map(x -> x.GUID()).collect(Collectors.toList());
                }
            };
        }

        @Override
        public T get() {
            return (T)((IGUID)this.type.getObject((String)this.getRaw()));
        }

        @Override
        public String toRaw(T t) {
            return t.GUID();
        }

        @Override
        public String fromJsonElement(MainSchema main, JsonElement element) {
            return element.getAsString();
        }

        @Override
        public void save(JsonObject json) {
            json.addProperty(this.id, (String)this.getRaw());
        }

        public static SchemaReq<String> validRegistry(RegType<?> type) {
            return new SchemaReq<String>(x -> type.hasObject((String)x), SchemaReq.VerifyTime.ON_DATAPACKS_LOADED, e -> e + " is not a registered object in " + type.getRegistryName() + " registry");
        }
    }

    public static class ID
    extends SchemaPart<ID, String, String> {
        public static ID EMPTY = new ID(EMPTY_HOLDER);

        public ID(ModSchema holder) {
            super(holder, "id", () -> new ID(EMPTY_HOLDER));
        }

        @Override
        public String toRaw(String t) {
            return t;
        }

        @Override
        public String get() {
            return (String)this.getRaw();
        }

        @Override
        public String fromJsonElement(MainSchema main, JsonElement element) {
            return element.getAsString();
        }

        @Override
        public void save(JsonObject json) {
            json.addProperty(this.id, (String)this.getRaw());
        }
    }

    public static class INT
    extends SchemaPart<INT, Integer, Integer> {
        public static INT EMPTY = new INT(EMPTY_HOLDER, EMPTY_ID);

        public INT(ModSchema holder, String id) {
            super(holder, id, () -> new INT(EMPTY_HOLDER, EMPTY_ID));
        }

        @Override
        public Integer toRaw(Integer t) {
            return t;
        }

        @Override
        public Integer get() {
            return (Integer)this.getRaw();
        }

        @Override
        public Integer fromJsonElement(MainSchema main, JsonElement element) {
            return element.getAsInt();
        }

        @Override
        public void save(JsonObject json) {
            json.addProperty(this.id, (Number)this.getRaw());
        }
    }
}

