/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.test;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.test.MainSchema;
import com.robertx22.test.SchemaPart;
import java.util.ArrayList;
import java.util.List;

public abstract class ModSchema<T> {
    public String id;
    public Supplier<ModSchema> sup;
    public List<SchemaPart> parts = new ArrayList<SchemaPart>();
    public List<ModSchema> schemas = new ArrayList<ModSchema>();

    public ModSchema<T> createNewInstance() {
        return (ModSchema)this.sup.get();
    }

    public ModSchema(ModSchema parent, String id, Supplier<ModSchema> sup) {
        this.id = id;
        this.sup = sup;
        if (parent != null || !(this instanceof MainSchema)) {
            Preconditions.checkArgument((parent != null ? 1 : 0) != 0);
            parent.schemas.add(this);
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (SchemaPart schemaPart : this.parts) {
            schemaPart.save(json);
        }
        for (ModSchema modSchema : this.schemas) {
            JsonObject inner = modSchema.toJson();
            json.add(modSchema.id, (JsonElement)inner);
        }
        return json;
    }

    public void load(MainSchema main, JsonObject json) {
        for (SchemaPart schemaPart : this.parts) {
            if (!json.has(schemaPart.id)) {
                if (schemaPart.isOptional()) {
                    schemaPart.object = schemaPart.optionalValue;
                } else {
                    throw new RuntimeException("Datapack error: " + schemaPart.id + " field inside " + main.id + " is missing and not optional!");
                }
            }
            JsonElement loaded = json.get(schemaPart.id);
            schemaPart.load(main, loaded);
        }
        for (ModSchema modSchema : this.schemas) {
            JsonObject inner = json.getAsJsonObject(modSchema.id);
            modSchema.load(main, inner);
        }
    }
}

