/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets.perks;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class PerkChangePacket
extends MyPacket<PerkChangePacket> {
    public String school;
    public int x;
    public int y;
    ACTION action;

    public PerkChangePacket() {
    }

    public PerkChangePacket(TalentTree school, PointData point, ACTION action) {
        this.school = school.identifier;
        this.x = point.x;
        this.y = point.y;
        this.action = action;
    }

    public ResourceLocation getIdentifier() {
        return new ResourceLocation("mmorpg", "perk_change");
    }

    public void loadFromData(FriendlyByteBuf tag) {
        this.school = tag.m_130136_(30);
        this.x = tag.readInt();
        this.y = tag.readInt();
        this.action = (ACTION)tag.m_130066_(ACTION.class);
    }

    public void saveToData(FriendlyByteBuf tag) {
        tag.m_130072_(this.school, 30);
        tag.writeInt(this.x);
        tag.writeInt(this.y);
        tag.m_130068_((Enum)this.action);
    }

    public void onReceived(ExilePacketContext ctx) {
        PlayerData playerData = Load.player(ctx.getPlayer());
        TalentTree sc = (TalentTree)ExileDB.TalentTrees().get(this.school);
        PlayerPointsType type = sc.getSchool_type().getPointType();
        if (sc == null) {
            ExileLog.get().warn("school is null: " + this.school, new Object[0]);
            return;
        }
        PointData point = new PointData(this.x, this.y);
        if (this.action == ACTION.ALLOCATE) {
            if (playerData.talents.canAllocate(sc, point, Load.Unit((Entity)ctx.getPlayer()), ctx.getPlayer())) {
                playerData.talents.allocate(ctx.getPlayer(), sc, new PointData(this.x, this.y));
            }
        } else if (this.action == ACTION.REMOVE && playerData.talents.canRemove(ctx.getPlayer(), sc, point)) {
            playerData.talents.remove(sc.getSchool_type(), new PointData(this.x, this.y));
            type.reduceResetPoints(ctx.getPlayer(), 1);
        }
        Load.Unit((Entity)ctx.getPlayer()).setEquipsChanged();
        playerData.playerDataSync.setDirty();
    }

    public MyPacket<PerkChangePacket> newInstance() {
        return new PerkChangePacket();
    }

    public static enum ACTION {
        ALLOCATE,
        REMOVE;

    }
}

