/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.database.data.profession.Crafting_State;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionBlockEntity;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LockTogglePacket
extends MyPacket<LockTogglePacket> {
    public BlockPos block_pos;

    public LockTogglePacket() {
    }

    public LockTogglePacket(BlockPos pos) {
        this.block_pos = pos;
    }

    public ResourceLocation getIdentifier() {
        return new ResourceLocation("mmorpg", "locktoggle");
    }

    public void loadFromData(FriendlyByteBuf friendlyByteBuf) {
        this.block_pos = friendlyByteBuf.m_130135_();
    }

    public void saveToData(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130064_(this.block_pos);
    }

    public void onReceived(ExilePacketContext exilePacketContext) {
        BlockEntity be = exilePacketContext.getPlayer().m_9236_().m_7702_(this.block_pos);
        if (be instanceof ProfessionBlockEntity) {
            ProfessionBlockEntity pbe = (ProfessionBlockEntity)be;
            if (pbe.getProfession().GUID().equals(Professions.SALVAGING)) {
                return;
            }
            if (pbe.craftingState == Crafting_State.ACTIVE && pbe.recipe_locked.booleanValue()) {
                if (pbe.ownerUUID != null && pbe.ownerUUID.compareTo(exilePacketContext.getPlayer().m_20148_()) == 0 || pbe.ownerUUID == null) {
                    exilePacketContext.getPlayer().m_213846_((Component)Component.m_237113_((String)"This Station is currently claimed by another player").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                }
            } else if (pbe.craftingState == Crafting_State.IDLE && pbe.recipe_locked.booleanValue()) {
                exilePacketContext.getPlayer().m_213846_((Component)Component.m_237113_((String)"Stop auto crafting before unlocking the recipe").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            } else if (pbe.craftingState == Crafting_State.STOPPED && pbe.recipe_locked.booleanValue()) {
                pbe.recipe_locked = false;
                pbe.last_recipe = null;
                if (pbe.ownerUUID != null && pbe.ownerUUID.compareTo(exilePacketContext.getPlayer().m_20148_()) != 0) {
                    // empty if block
                }
            } else if (pbe.craftingState == Crafting_State.ACTIVE && !pbe.recipe_locked.booleanValue()) {
                exilePacketContext.getPlayer().m_213846_((Component)Component.m_237113_((String)"Stop auto crafting before locking the recipe").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            } else if (pbe.craftingState == Crafting_State.STOPPED && !pbe.recipe_locked.booleanValue()) {
                ProfessionRecipe recipe = pbe.getCurrentRecipe();
                if (recipe == null) {
                    exilePacketContext.getPlayer().m_213846_((Component)Chats.PROF_RECIPE_NOT_SELECTED.locName().m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                    return;
                }
                int ownerLvl = Load.player((Player)exilePacketContext.getPlayer()).professions.getLevel(recipe.profession);
                if (recipe.getLevelRequirement() > ownerLvl) {
                    exilePacketContext.getPlayer().m_213846_((Component)Chats.PROF_RECIPE_LEVEL_NOT_ENOUGH.locName(recipe.profession, recipe.getLevelRequirement(), ownerLvl).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                    return;
                }
                pbe.recipe_locked = true;
                pbe.last_recipe = recipe;
                ItemStack showstack = recipe.toResultStackForJei();
                showstack.m_41764_(1);
            } else {
                exilePacketContext.getPlayer().m_213846_((Component)Component.m_237113_((String)("Unhandled Case(Report The Following):  " + pbe.recipe_locked + " + " + pbe.craftingState.name())).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            }
            pbe.m_6596_();
        }
    }

    public MyPacket<LockTogglePacket> newInstance() {
        return new LockTogglePacket();
    }
}

