/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.spell_school.SpellSchool;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellSchoolsData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class AllocateClassPointPacket
extends MyPacket<AllocateClassPointPacket> {
    public String id;
    public String schoolid;
    ACTION action;

    public AllocateClassPointPacket() {
    }

    public AllocateClassPointPacket(SpellSchool school, Perk perk, ACTION action) {
        this.id = perk.GUID();
        this.schoolid = school.GUID();
        this.action = action;
    }

    public ResourceLocation getIdentifier() {
        return new ResourceLocation("mmorpg", "spell_alloc");
    }

    public void loadFromData(FriendlyByteBuf tag) {
        this.id = tag.m_130136_(100);
        this.schoolid = tag.m_130136_(100);
        this.action = (ACTION)tag.m_130066_(ACTION.class);
    }

    public void saveToData(FriendlyByteBuf tag) {
        tag.m_130072_(this.id, 100);
        tag.m_130072_(this.schoolid, 100);
        tag.m_130068_((Enum)this.action);
    }

    public void onReceived(ExilePacketContext ctx) {
        Perk perk = (Perk)ExileDB.Perks().get(this.id);
        SpellSchool school = (SpellSchool)ExileDB.SpellSchools().get(this.schoolid);
        SpellSchoolsData data = Load.player((Player)ctx.getPlayer()).ascClass;
        if (this.action == ACTION.ALLOCATE) {
            ExplainedResult res = data.canLearn(ctx.getPlayer(), school, perk);
            if (res.can) {
                data.learn(perk, school);
            } else {
                ctx.getPlayer().m_213846_(res.answer);
            }
        } else if (data.canUnlearn(ctx.getPlayer(), school, perk)) {
            data.unlearn(ctx.getPlayer(), perk, school);
        }
        Load.Unit((Entity)ctx.getPlayer()).setEquipsChanged();
        Load.player((Player)ctx.getPlayer()).playerDataSync.setDirty();
    }

    public MyPacket<AllocateClassPointPacket> newInstance() {
        return new AllocateClassPointPacket();
    }

    public static enum ACTION {
        ALLOCATE,
        REMOVE;

    }
}

