/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes;

import com.robertx22.addons.orbs_of_crafting.currency.IItemAsCurrency;
import com.robertx22.addons.orbs_of_crafting.currency.base.CodeCurrency;
import com.robertx22.addons.orbs_of_crafting.currency.base.GearCurrency;
import com.robertx22.addons.orbs_of_crafting.currency.base.GearOutcome;
import com.robertx22.addons.orbs_of_crafting.currency.base.OutcomeType;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.ResourceStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.ResourceAndAttack;
import com.robertx22.mine_and_slash.aoe_data.database.stats.old.DatapackStats;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.IAutoModel;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.ItemModelManager;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.gems.Gem;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.EnergyRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.HealthRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.ManaRegen;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.GemItems;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.SocketData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.uncommon.IShapelessRecipe;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.BaseGemItem;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.GemStatPerTypes;
import com.robertx22.orbs_of_crafting.misc.LocReqContext;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GemItem
extends BaseGemItem
implements IGUID,
IAutoModel,
IItemAsCurrency,
IWeighted,
IShapelessRecipe {
    static float MIN_WEP_DMG = 2.0f;
    static float MAX_WEP_DMG = 15.0f;
    static float MIN_RES = 5.0f;
    static float MAX_RES = 15.0f;
    static float MIN_ELE_DMG = 2.0f;
    static float MAX_ELE_DMG = 10.0f;
    public GemType gemType;
    public GemRank gemRank;
    public float levelToStartDrop;

    public Component m_7626_(ItemStack stack) {
        return Formatter.GEM_ITEM_NAME.locName(this.gemRank.locName(), this.gemType.locName()).m_130940_(this.gemType.format);
    }

    @Override
    public ShapelessRecipeBuilder getRecipe() {
        if (this.gemRank.lower() == null) {
            return null;
        }
        return ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)GemItems.MAP.get(this.gemType).get(this.gemRank).get())).m_126211_((ItemLike)GemItems.MAP.get(this.gemType).get(this.gemRank.lower()).get(), 3).m_126132_("player_level", this.trigger());
    }

    public int Weight() {
        return this.weight;
    }

    @Override
    public void generateModel(ItemModelManager manager) {
        manager.generated(this);
    }

    @Override
    public Gem getBaseGem() {
        return this.getGem();
    }

    @Override
    public float getStatValueMulti() {
        return this.gemRank.statmulti;
    }

    @Override
    public List<StatMod> getStatModsForSerialization(SlotFamily family) {
        return this.gemType.stats.getFor(family);
    }

    @Override
    public CodeCurrency currencyEffect(ItemStack stack) {
        return new GearCurrency(){

            @Override
            public List<GearOutcome> getOutcomes() {
                return Arrays.asList(new GearOutcome(){

                    @Override
                    public Words getName() {
                        return Words.None;
                    }

                    @Override
                    public OutcomeType getOutcomeType() {
                        return OutcomeType.GOOD;
                    }

                    @Override
                    public void modify(LocReqContext ctx) {
                        ExileStack ex = ExileStack.of(ctx.stack);
                        ex.get(StackKeys.GEAR).edit(gear -> {
                            GemItem gitem = (GemItem)ctx.Currency.m_41720_();
                            Gem gem = gitem.getGem();
                            SocketData socket = new SocketData();
                            socket.g = gem.identifier;
                            gear.sockets.getSocketed().add(socket);
                            ctx.player.m_5661_((Component)Chats.GEM_SOCKETED.locName(), false);
                        });
                        ctx.stack = ex.getStack();
                    }

                    public int Weight() {
                        return 1000;
                    }
                });
            }

            @Override
            public int getPotentialLoss() {
                return 0;
            }

            @Override
            public ExplainedResult canBeModified(LocReqContext c) {
                ExileStack ex = ExileStack.of(c.stack);
                ItemStack stack = c.stack;
                GearItemData data = ex.get(StackKeys.GEAR).get();
                if (data.getEmptySockets() < 1) {
                    return ExplainedResult.failure((Component)Chats.NEED_EMPTY_SOCKET.locName());
                }
                GearRarity rar = data.getRarity();
                int gems = (int)data.sockets.getSocketed().stream().filter(x -> x.isGem()).count();
                if (rar.max_gems > 0) {
                    if (gems >= rar.max_gems) {
                        return ExplainedResult.failure((Component)Chats.RARITY_CANT_HAVE_MORE_THAN_X_GEMS.locName(rar.coloredName(), rar.max_gems));
                    }
                } else {
                    return ExplainedResult.failure((Component)Chats.RARITY_CANT_HAVE_ANY_GEMS.locName(rar.coloredName()));
                }
                return ExplainedResult.success();
            }

            @Override
            public String locDescForLangFile() {
                return "Sockets the gem";
            }

            @Override
            public String locNameForLangFile() {
                return this.locNameForLangFile();
            }

            public String GUID() {
                return this.GUID();
            }

            public int Weight() {
                return GemItem.this.weight;
            }
        };
    }

    public GemItem(GemType type, GemRank gemRank) {
        super(new Item.Properties().m_41487_(16));
        this.gemType = type;
        this.gemRank = gemRank;
        this.weight = gemRank.weight;
        this.levelToStartDrop = gemRank.lvlToDropmulti;
    }

    public String GUID() {
        return "gems/" + this.gemType.id + "/" + this.gemRank.tier;
    }

    public Gem getGem() {
        String id = VanillaUTIL.REGISTRY.items().getKey((Object)this).toString();
        Optional<Gem> opt = ExileDB.Gems().getList().stream().filter(x -> id.equals(x.item_id)).findFirst();
        return opt.orElse(new Gem());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        try {
            tooltip.addAll(this.getBaseTooltip());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum GemRank implements IAutoLocName
    {
        CRACKED("Cracked", 0, 0.1f, 100, 100999, 0.0f, "common"),
        CHIPPED("Chipped", 1, 0.2f, 75, 25999, 0.1f, "common"),
        FLAWED("Flawed", 2, 0.3f, 50, 5000, 0.2f, "uncommon"),
        REGULAR("Regular", 3, 0.4f, 25, 1000, 0.5f, "rare"),
        GRAND("Grand", 4, 0.6f, 10, 200, 0.75f, "epic"),
        GLORIOUS("Glorious", 5, 0.8f, 5, 25, 0.9f, "legendary"),
        DIVINE("Divine", 6, 1.0f, 0, 1, 0.95f, "mythic");

        public String rar;
        public String locName;
        public int tier;
        public float statmulti;
        public int upgradeChance;
        public int weight;
        public float lvlToDropmulti;

        private GemRank(String locName, int tier, float statmulti, int upgradeChance, int weight, float lvlToDropmulti, String rar) {
            this.locName = locName;
            this.rar = rar;
            this.weight = weight;
            this.lvlToDropmulti = lvlToDropmulti;
            this.tier = tier;
            this.statmulti = statmulti;
            this.upgradeChance = upgradeChance;
        }

        public static GemRank ofTier(int tier) {
            for (GemRank gr : GemRank.values()) {
                if (gr.tier != tier) continue;
                return gr;
            }
            return CHIPPED;
        }

        public GemRank lower() {
            for (GemRank gr : GemRank.values()) {
                if (gr.tier != this.tier - 1) continue;
                return gr;
            }
            return null;
        }

        @Override
        public IBaseAutoLoc.AutoLocGroup locNameGroup() {
            return IBaseAutoLoc.AutoLocGroup.Misc;
        }

        @Override
        public String locNameLangFileGUID() {
            return "mmorpg.gem_rank." + this.GUID();
        }

        @Override
        public String locNameForLangFile() {
            return this.locName;
        }

        public String GUID() {
            return this.locName.toLowerCase(Locale.ROOT);
        }
    }

    public static enum GemType implements IAutoLocName
    {
        TOURMALINE("tourmaline", "Tourmaline", ChatFormatting.LIGHT_PURPLE, new GemStatPerTypes(){

            @Override
            public List<StatMod> onArmor() {
                return Arrays.asList(new StatMod(1.0f, 5.0f, DatapackStats.STR));
            }

            @Override
            public List<StatMod> onJewelry() {
                return Arrays.asList(new StatMod(2.0f, 15.0f, HealthRegen.getInstance(), ModType.PERCENT));
            }

            @Override
            public List<StatMod> onWeapons() {
                return Arrays.asList(new StatMod(1.0f, 5.0f, ResourceStats.LIFESTEAL.get()));
            }
        }),
        AZURITE("azurite", "Azurite", ChatFormatting.AQUA, new GemStatPerTypes(){

            @Override
            public List<StatMod> onArmor() {
                return Arrays.asList(new StatMod(1.0f, 5.0f, DatapackStats.INT));
            }

            @Override
            public List<StatMod> onJewelry() {
                return Arrays.asList(new StatMod(2.0f, 15.0f, ManaRegen.getInstance(), ModType.PERCENT));
            }

            @Override
            public List<StatMod> onWeapons() {
                return Arrays.asList(new StatMod(1.0f, 3.0f, ResourceStats.RESOURCE_ON_HIT.get(new ResourceAndAttack(ResourceType.mana, AttackType.hit))));
            }
        }),
        GARNET("garnet", "Garnet", ChatFormatting.GREEN, new GemStatPerTypes(){

            @Override
            public List<StatMod> onArmor() {
                return Arrays.asList(new StatMod(1.0f, 5.0f, DatapackStats.DEX));
            }

            @Override
            public List<StatMod> onJewelry() {
                return Arrays.asList(new StatMod(2.0f, 15.0f, EnergyRegen.getInstance(), ModType.PERCENT));
            }

            @Override
            public List<StatMod> onWeapons() {
                return Arrays.asList(new StatMod(2.0f, 8.0f, OffenseStats.CRIT_CHANCE.get()));
            }
        }),
        OPAL("opal", "Opal", ChatFormatting.GOLD, new GemStatPerTypes(){

            @Override
            public List<StatMod> onArmor() {
                return Arrays.asList(new StatMod(1.0f, 5.0f, DatapackStats.STR));
            }

            @Override
            public List<StatMod> onJewelry() {
                return Arrays.asList(new StatMod(1.0f, 4.0f, OffenseStats.CRIT_CHANCE.get()));
            }

            @Override
            public List<StatMod> onWeapons() {
                return Arrays.asList(new StatMod(3.0f, 15.0f, OffenseStats.CRIT_DAMAGE.get()));
            }
        }),
        TOPAZ("topaz", "Topaz", ChatFormatting.YELLOW, new GemStatPerTypes(){

            @Override
            public List<StatMod> onArmor() {
                return Arrays.asList(new StatMod(1.0f, 5.0f, DatapackStats.INT));
            }

            @Override
            public List<StatMod> onJewelry() {
                return Arrays.asList(new StatMod(2.0f, 15.0f, Energy.getInstance(), ModType.PERCENT));
            }

            @Override
            public List<StatMod> onWeapons() {
                return Arrays.asList(new StatMod(3.0f, 15.0f, OffenseStats.CRIT_DAMAGE.get()));
            }
        }),
        AMETHYST("amethyst", "Amethyst", ChatFormatting.DARK_PURPLE, new EleGem(Elements.Shadow)),
        RUBY("ruby", "Ruby", ChatFormatting.RED, new EleGem(Elements.Fire)),
        EMERALD("emerald", "Emerald", ChatFormatting.GREEN, new EleGem(Elements.Shadow)),
        SAPPHIRE("sapphire", "Sapphire", ChatFormatting.BLUE, new EleGem(Elements.Cold));

        public String locName;
        public String id;
        public ChatFormatting format;
        public GemStatPerTypes stats;

        private GemType(String id, String locName, ChatFormatting format, GemStatPerTypes stats) {
            this.locName = locName;
            this.id = id;
            this.format = format;
            this.stats = stats;
        }

        @Override
        public IBaseAutoLoc.AutoLocGroup locNameGroup() {
            return IBaseAutoLoc.AutoLocGroup.Misc;
        }

        @Override
        public String locNameLangFileGUID() {
            return "mmorpg.gem_type." + this.GUID();
        }

        @Override
        public String locNameForLangFile() {
            return this.locName;
        }

        public String GUID() {
            return this.id;
        }
    }

    public static class EleGem
    extends GemStatPerTypes {
        public Elements ele;

        public EleGem(Elements ele) {
            this.ele = ele;
        }

        @Override
        public List<StatMod> onArmor() {
            return Arrays.asList(new StatMod(MIN_RES, MAX_RES, new ElementalResist(this.ele), ModType.FLAT));
        }

        @Override
        public List<StatMod> onJewelry() {
            return Arrays.asList(new StatMod(MIN_ELE_DMG, MAX_ELE_DMG, OffenseStats.ELEMENTAL_SPELL_DAMAGE.get(this.ele)));
        }

        @Override
        public List<StatMod> onWeapons() {
            return Arrays.asList(new StatMod(5.0f, 25.0f, OffenseStats.ELEMENTAL_DAMAGE.get(this.ele), ModType.FLAT));
        }
    }
}

