/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.database.OptScaleExactStat;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.gems.Gem;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.StatBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.DropChanceBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.DropLevelBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.loot.generators.GemLootGen;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;

public abstract class BaseGemItem
extends Item {
    public int weight;

    public BaseGemItem(Item.Properties settings) {
        super(settings);
    }

    public abstract Gem getBaseGem();

    public abstract float getStatValueMulti();

    public abstract List<StatMod> getStatModsForSerialization(SlotFamily var1);

    public List<OptScaleExactStat> getStatsForSerialization(SlotFamily family) {
        ArrayList<OptScaleExactStat> list = new ArrayList<OptScaleExactStat>();
        float multi = this.getStatValueMulti();
        this.getStatModsForSerialization(family).forEach(x -> {
            OptScaleExactStat stat = new OptScaleExactStat(x.max * multi, x.GetStat(), x.getModType());
            stat.scale_to_lvl = true;
            list.add(stat);
        });
        return list;
    }

    public List<Component> getBaseTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (ExileDB.Runes().isEmpty() || ExileDB.Gems().isEmpty() || this.getBaseGem() == null) {
            return tooltip;
        }
        ExileTooltips t = new ExileTooltips();
        final Gem gem = this.getBaseGem();
        t.accept(new RarityBlock(gem.getRarity()));
        t.accept(new StatBlock(){

            @Override
            public List<? extends Component> getAvailableComponents() {
                ArrayList<MutableComponent> stats = new ArrayList<MutableComponent>();
                StatRangeInfo info = new StatRangeInfo(ModRange.hide());
                stats.add(Component.m_237113_((String)""));
                List<OptScaleExactStat> wep = gem.getFor(SlotFamily.Weapon);
                stats.add(Words.WEAPON.locName().m_130940_(ChatFormatting.RED));
                for (OptScaleExactStat optScaleExactStat : wep) {
                    stats.addAll(optScaleExactStat.GetTooltipString(info));
                }
                stats.add(Component.m_237113_((String)""));
                List<OptScaleExactStat> armor = gem.getFor(SlotFamily.Armor);
                stats.add(Words.ARMOR.locName().m_130940_(ChatFormatting.BLUE));
                for (OptScaleExactStat x : armor) {
                    stats.addAll(x.GetTooltipString(info));
                }
                stats.add(Component.m_237113_((String)""));
                List<OptScaleExactStat> list = gem.getFor(SlotFamily.Jewelry);
                stats.add(Words.JEWERLY.locName().m_130940_(ChatFormatting.LIGHT_PURPLE));
                for (OptScaleExactStat x : list) {
                    stats.addAll(x.GetTooltipString(info));
                }
                return stats;
            }
        });
        t.accept(WorksOnBlock.usableOn(WorksOnBlock.ItemType.GEAR));
        t.accept(new UsageBlock(Arrays.asList(Itemtips.GEM_ITEM_USAGE.locName().m_130940_(ChatFormatting.BLUE))));
        t.accept(new DropLevelBlock(gem.getReqLevelToDrop(), GameBalanceConfig.get().MAX_LEVEL));
        t.accept(new OperationTipBlock().setAlt().setShift());
        int lvl = Load.Unit((Entity)ClientOnly.getPlayer()).getLevel();
        t.accept(new DropChanceBlock(GemLootGen.droppableAtLevel(lvl).getDropChance((ExileRegistry)gem)));
        return t.release();
    }
}

