/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.auto_salvage;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.support_gem.SupportGem;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class AutoSalvageGenericShow {
    ExileRegistryType registryType;

    public AutoSalvageGenericShow(ExileRegistryType registryType) {
        this.registryType = registryType;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(Commands.m_82127_((String)"auto_salvage").then(Commands.m_82127_((String)"show").then(((LiteralArgumentBuilder)Commands.m_82127_((String)this.registryType.id).executes(e -> this.execute((CommandSourceStack)e.getSource(), (Player)((CommandSourceStack)e.getSource()).m_81375_(), null))).then(Commands.m_82129_((String)"search_query", (ArgumentType)StringArgumentType.word()).executes(e -> this.execute((CommandSourceStack)e.getSource(), (Player)((CommandSourceStack)e.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)e, (String)"search_query"))))))));
    }

    private int execute(CommandSourceStack commandSource, Player player, String searchQuery) {
        if (Objects.isNull(player)) {
            try {
                player = commandSource.m_81375_();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return 0;
            }
        }
        ToggleAutoSalvageRarity.SalvageType salvageType = this.registryType == ExileRegistryTypes.GEAR_SLOT ? ToggleAutoSalvageRarity.SalvageType.GEAR : ToggleAutoSalvageRarity.SalvageType.SPELL;
        PlayerConfigData playerConfigData = Load.player((Player)player).config;
        HashMap<String, Boolean> configuredMap = playerConfigData.salvage.getConfiguredMapForSalvageType(salvageType);
        if (configuredMap.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)("There are no currently configured options for " + this.registryType.id + " items.")).m_130940_(ChatFormatting.GRAY));
            return 1;
        }
        if (searchQuery == null) {
            player.m_213846_((Component)Component.m_237113_((String)("--- Listing all configured " + this.registryType.id + " ids ---")));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)("--- Listing configured " + this.registryType.id + " ids matching: " + searchQuery + " ---")));
        }
        MutableComponent enabledTextComponent = Component.m_237113_((String)"ENABLED").m_130940_(ChatFormatting.GREEN);
        MutableComponent disabledTextComponent = Component.m_237113_((String)"DISABLED").m_130940_(ChatFormatting.RED);
        for (String id : configuredMap.keySet()) {
            Boolean enabled = configuredMap.get(id);
            if (this.registryType == ExileRegistryTypes.SUPPORT_GEM) {
                SupportGem gem = (SupportGem)ExileDB.SupportGems().get(id);
                if (searchQuery != null && !gem.id.toLowerCase().contains(searchQuery.toLowerCase()) && !gem.locName().getString().toLowerCase().contains(searchQuery.toLowerCase())) continue;
                player.m_213846_((Component)Component.m_237113_((String)("[" + gem.id + "] " + gem.locName().getString() + " [")).m_7220_((Component)(enabled != false ? enabledTextComponent : disabledTextComponent)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.WHITE)));
                continue;
            }
            if (searchQuery != null && !id.toLowerCase().contains(searchQuery.toLowerCase())) continue;
            player.m_213846_((Component)Component.m_237113_((String)(id + " [")).m_7220_((Component)(enabled != false ? enabledTextComponent : disabledTextComponent)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.WHITE)));
        }
        player.m_213846_((Component)Component.m_237113_((String)"---~---"));
        return 1;
    }
}

