/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.auto_salvage;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.mine_and_slash.database.data.support_gem.SupportGem;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import com.robertx22.mine_and_slash.vanilla_mc.commands.suggestions.DatabaseSuggestions;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class AutoSalvageGenericList {
    ExileRegistryType registryType;

    public AutoSalvageGenericList(ExileRegistryType registryType) {
        this.registryType = registryType;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(Commands.m_82127_((String)"auto_salvage").then(Commands.m_82127_((String)"list").then(((LiteralArgumentBuilder)Commands.m_82127_((String)this.registryType.id).executes(e -> this.execute((CommandSourceStack)e.getSource(), (Player)((CommandSourceStack)e.getSource()).m_81375_(), null))).then(Commands.m_82129_((String)"search_query", (ArgumentType)StringArgumentType.word()).executes(e -> this.execute((CommandSourceStack)e.getSource(), (Player)((CommandSourceStack)e.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)e, (String)"search_query"))))))));
    }

    private int execute(CommandSourceStack commandSource, Player player, String searchQuery) {
        List allIdsSorted = new DatabaseSuggestions(this.registryType, null).suggestions().stream().sorted().toList();
        if (Objects.isNull(player)) {
            try {
                player = commandSource.m_81375_();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return 0;
            }
        }
        if (searchQuery == null) {
            player.m_213846_((Component)Component.m_237113_((String)("--- Listing All " + this.registryType.id + " ids ---")));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)("--- Listing " + this.registryType.id + "ids matching: " + searchQuery + " ---")));
        }
        for (String id : allIdsSorted) {
            if (this.registryType == ExileRegistryTypes.SUPPORT_GEM) {
                SupportGem gem = (SupportGem)ExileDB.SupportGems().get(id);
                if (searchQuery != null && !gem.id.toLowerCase().contains(searchQuery) && !gem.locName().getString().toLowerCase().contains(searchQuery.toLowerCase())) continue;
                player.m_213846_((Component)Component.m_237113_((String)("[" + gem.id + "] " + gem.locName().getString())));
                continue;
            }
            if (searchQuery != null && !id.toLowerCase().contains(searchQuery.toLowerCase())) continue;
            player.m_213846_((Component)Component.m_237113_((String)id));
        }
        player.m_213846_((Component)Component.m_237113_((String)"---~---"));
        return 1;
    }
}

