/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.auto_salvage;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.robertx22.library_of_exile.command_wrapper.CommandSuggestions;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import com.robertx22.mine_and_slash.vanilla_mc.commands.suggestions.DatabaseSuggestions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.command.EnumArgument;

public class AutoSalvageGenericConfigure {
    ExileRegistryType registryType;

    public AutoSalvageGenericConfigure(ExileRegistryType registryType) {
        this.registryType = registryType;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(Commands.m_82127_((String)"auto_salvage").then(Commands.m_82127_((String)"config").then(Commands.m_82127_((String)this.registryType.id).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DatabaseSuggestions(this.registryType, null)).then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(AutoSalvageConfigAction.class)).suggests((SuggestionProvider)new EnableDisableSuggestions()).executes(e -> this.execute((CommandSourceStack)e.getSource(), (Player)((CommandSourceStack)e.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)e, (String)"type"), (AutoSalvageConfigAction)((Object)((Object)e.getArgument("action", AutoSalvageConfigAction.class)))))))))));
    }

    private int execute(CommandSourceStack commandSource, Player player, String typeId, AutoSalvageConfigAction action) {
        List<String> allTypeIds = new DatabaseSuggestions(this.registryType, null).suggestions();
        if (!allTypeIds.contains(typeId)) {
            player.m_213846_((Component)Component.m_237113_((String)("The type provided: " + typeId + ", for (" + this.registryType.id + ") is not valid.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (Objects.isNull(player)) {
            try {
                player = commandSource.m_81375_();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return 0;
            }
        }
        PlayerConfigData playerConfigData = Load.player((Player)player).config;
        ToggleAutoSalvageRarity.SalvageType salvageType = this.registryType == ExileRegistryTypes.GEAR_SLOT ? ToggleAutoSalvageRarity.SalvageType.GEAR : ToggleAutoSalvageRarity.SalvageType.SPELL;
        playerConfigData.salvage.setAutoSalvageForTypeAndId(salvageType, typeId, action);
        Load.player((Player)player).playerDataSync.setDirty();
        player.m_213846_((Component)Component.m_237113_((String)("Successfully updated auto_salvage settings for " + this.registryType.id + ": " + typeId + " to " + action.getLowercasePastTense())).m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    public static enum AutoSalvageConfigAction {
        ENABLE,
        DISABLE,
        CLEAR;


        public static List<String> getStringValues() {
            return Arrays.stream(AutoSalvageConfigAction.values()).map(Enum::name).toList();
        }

        public String getLowercasePastTense() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CLEAR -> "cleared";
                case ENABLE -> "enabled";
                case DISABLE -> "disabled";
            };
        }
    }

    private static class EnableDisableSuggestions
    extends CommandSuggestions {
        private EnableDisableSuggestions() {
        }

        public List<String> suggestions() {
            return AutoSalvageConfigAction.getStringValues();
        }
    }
}

