/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.robertx22.library_of_exile.command_wrapper.CommandSuggestions;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ListStatSourcesCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dis) {
        dis.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list_stat_sources").requires(e -> e.m_6761_(0))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new Sugg()).executes(ctx -> ListStatSourcesCommand.run((Player)((CommandSourceStack)ctx.getSource()).m_230896_(), StringArgumentType.getString((CommandContext)ctx, (String)"type"))))));
    }

    private static int run(Player en, String id) {
        try {
            en.m_213846_((Component)Component.m_237113_((String)"Sources of ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)((Stat)ExileDB.Stats().get(id)).locName()));
            for (SimpleStatCtx ctx : Load.player((Player)en).ctxs.list) {
                for (ExactStatData stat : ctx.stats) {
                    if (!stat.getStat().GUID().equals(id)) continue;
                    String s = ctx.type.name() + ": ";
                    if (!ctx.gear_slot.isEmpty()) {
                        s = s + ctx.gear_slot + ". ";
                    }
                    s = s + stat.getValue() + " " + stat.getType().name();
                    en.m_213846_((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.YELLOW));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public static class Sugg
    extends CommandSuggestions {
        public List<String> suggestions() {
            return ExileDB.Stats().getAll().values().stream().map(x -> x.GUID()).collect(Collectors.toList());
        }
    }
}

