/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.DimensionConfig;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.level_ranges.LevelRange;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.levels.LevelInfo;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.MapManager;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import com.robertx22.temp.SkillItemTier;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class LevelUtils {
    public static String OBELISK_DIM = "ancient_obelisks:obelisk";
    public static String HARVEST_DIM = "the_harvest:harvest";

    public static int getMaxTier() {
        return LevelUtils.levelToTier(GameBalanceConfig.get().MAX_LEVEL);
    }

    public static void runTests() {
        if (MMORPG.RUN_DEV_TOOLS) {
            // empty if block
        }
    }

    public static LevelRange tierToLevel(int tier) {
        return SkillItemTier.of((int)tier).levelRange;
    }

    public static int levelToTier(int level) {
        return SkillItemTier.fromLevel((int)level).tier;
    }

    public static float getMaxLevelMultiplier(float lvl) {
        float max = GameBalanceConfig.get().MAX_LEVEL;
        return lvl / max;
    }

    public static int getExpRequiredForLevel(int level) {
        return (int)Math.pow(10.0f * GameBalanceConfig.get().NORMAL_STAT_SCALING.getMultiFor(level), 2.4f);
    }

    public static int getBaseExpMobReward(int level) {
        return 50 + LevelUtils.scaleExpReward(4, level);
    }

    public static int scaleExpReward(int exp, int level) {
        return (int)Math.pow((float)exp * GameBalanceConfig.get().NORMAL_STAT_SCALING.getMultiFor(level), 1.1f);
    }

    public static LevelInfo determineLevel(@Nullable LivingEntity en, Level world, BlockPos pos, @Nullable Player nearestPlayer, boolean usevariance) {
        LevelInfo info = new LevelInfo();
        ServerLevel sw = (ServerLevel)world;
        Optional<MapData> opt = WorldUtils.ifMapData(world, pos);
        boolean scaletoPlayer = false;
        boolean ignoreEntityConfig = false;
        if (opt.isPresent()) {
            MapData data = opt.get();
            if (data != null) {
                info.set(LevelInfo.LevelSource.MAP_DIMENSION, data.map.getLevel());
                return info;
            }
            System.out.print("A mob spawned in a dungeon world without a dungeon data nearby!");
        } else {
            String dimid = MapManager.getResourceLocation(world).toString();
            if (dimid.equals(OBELISK_DIM) || dimid.equals(HARVEST_DIM)) {
                scaletoPlayer = true;
                ignoreEntityConfig = true;
            }
        }
        DimensionConfig dimConfig = ExileDB.getDimensionConfig((LevelAccessor)world);
        if ((scaletoPlayer || ((Boolean)ServerContainer.get().SCALE_MOB_LEVEL_TO_NEAREST_PLAYER.get()).booleanValue()) && nearestPlayer != null) {
            info.set(LevelInfo.LevelSource.NEAREST_PLAYER_CONFIG, Load.Unit((Entity)nearestPlayer).getLevel());
        } else if (LevelUtils.isInMinLevelArea(sw, pos, dimConfig)) {
            info.set(LevelInfo.LevelSource.MIN_LEVEL_AREA, dimConfig.min_lvl);
        } else if (dimConfig.scale_to_nearest_player && nearestPlayer != null) {
            info.set(LevelInfo.LevelSource.NEAREST_PLAYER, Load.Unit((Entity)nearestPlayer).getLevel());
        } else {
            info.set(LevelInfo.LevelSource.DISTANCE_FROM_SPAWN, LevelUtils.determineLevelPerDistanceFromSpawn(sw, pos, dimConfig));
        }
        if (usevariance) {
            Integer varianceConfig = (Integer)ServerContainer.get().MOB_LEVEL_VARIANCE.get();
            int variance = RandomUtils.RandomRange((int)(-varianceConfig.intValue()), (int)varianceConfig);
            info.add(LevelInfo.LevelSource.LEVEL_VARIANCE, variance);
        }
        info.capToRange(LevelInfo.LevelSource.DIMENSION, dimConfig.getLevelRangeFor(nearestPlayer));
        info.capToRange(LevelInfo.LevelSource.MAX_LEVEL, new MinMax(1, GameBalanceConfig.get().MAX_LEVEL));
        if (en != null && !ignoreEntityConfig) {
            EntityConfig enconfig = ExileDB.getEntityConfig(en, Load.Unit((Entity)en));
            info.capToRange(LevelInfo.LevelSource.ENTITY_CONFIG, new MinMax(enconfig.min_lvl, enconfig.max_lvl));
        }
        return info;
    }

    public static boolean isInMinLevelArea(ServerLevel world, BlockPos pos, DimensionConfig config) {
        double distance = world.m_220360_().m_123333_((Vec3i)pos);
        double scale = Mth.m_14008_((double)(world.m_6042_().f_63859_() / 3.0), (double)1.0, (double)2.147483647E9);
        return (distance *= scale) < (double)config.min_lvl_area;
    }

    public static int determineLevelPerDistanceFromSpawn(ServerLevel world, BlockPos pos, DimensionConfig config) {
        double distance = world.m_220360_().m_123333_((Vec3i)pos);
        double scale = Mth.m_14008_((double)(world.m_6042_().f_63859_() / 3.0), (double)1.0, (double)2.147483647E9);
        if ((distance *= scale) < (double)config.min_lvl_area) {
            return config.min_lvl;
        }
        int lvl = 1;
        lvl = (int)((double)config.min_lvl + (distance - (double)config.min_lvl_area) / (double)config.mob_lvl_per_distance);
        return Mth.m_14045_((int)lvl, (int)config.min_lvl, (int)config.max_lvl);
    }
}

