/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TeamUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Utilities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityFinder {
    public static boolean isTamedByAlly(Player other, LivingEntity x) {
        if (x instanceof OwnableEntity) {
            Player p;
            OwnableEntity tame = (OwnableEntity)x;
            LivingEntity livingEntity = tame.m_269323_();
            return livingEntity instanceof Player && TeamUtils.areOnSameTeam(other, p = (Player)livingEntity, false);
        }
        return false;
    }

    public static <T extends LivingEntity> Setup<T> start(Entity caster, Class<T> entityType, Vec3 pos) {
        Setup<T> setup = new Setup<T>(caster, entityType, pos);
        return setup;
    }

    public static <T extends LivingEntity> Setup<T> start(Entity caster, Class<T> entityType, BlockPos p) {
        return EntityFinder.start(caster, entityType, new Vec3((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_()));
    }

    public static class Setup<T extends LivingEntity> {
        Predicate<T> pred = x -> true;
        List<T> excluded = new ArrayList<T>();
        Class<T> entityType;
        SelectionType selectionType = SelectionType.RADIUS;
        AllyOrEnemy entityPredicate = AllyOrEnemy.enemies;
        Entity caster;
        boolean forceExcludeCaster = false;
        Level world;
        Vec3 pos;
        double radius = 1.0;
        double horizontal = 1.0;
        double vertical = 1.0;
        boolean addTestParticles = false;
        double distanceToSearch = 10.0;

        public Setup(Entity caster, Class<T> entityType, Vec3 pos) {
            Objects.requireNonNull(caster);
            this.entityType = entityType;
            this.caster = caster;
            this.world = caster.m_9236_();
            this.pos = pos;
        }

        public List<T> build() {
            Objects.requireNonNull(this.caster, "Caster can't be null");
            Objects.requireNonNull(this.caster, "Blockpos can't be null");
            Objects.requireNonNull(this.caster, "World can't be null");
            List list = this.selectionType.getEntities(this);
            list.removeIf(x -> x == null);
            list = this.entityPredicate.getMatchingEntities(list, this.caster);
            if (this.forceExcludeCaster || !this.entityPredicate.includesCaster()) {
                list.removeIf(x -> x == this.caster);
            }
            list.removeIf(x -> !x.m_6084_());
            list.removeIf(x -> this.excluded.contains(x));
            list.removeIf(x -> !this.pred.test((LivingEntity)x));
            return list;
        }

        public LivingEntity getClosest() {
            List<T> list = this.build();
            if (list.isEmpty()) {
                return null;
            }
            LivingEntity en = list.stream().min(Comparator.comparingInt(x -> (int)x.m_20270_(this.caster))).get();
            return en;
        }

        public Setup<T> finder(SelectionType f) {
            this.selectionType = f;
            return this;
        }

        public Setup<T> predicate(Predicate<T> p) {
            this.pred = p;
            return this;
        }

        public Setup<T> searchFor(AllyOrEnemy f) {
            this.entityPredicate = f;
            return this;
        }

        public Setup<T> distance(double distance) {
            this.distanceToSearch = distance;
            return this;
        }

        public Setup<T> height(double rad) {
            this.vertical = rad;
            return this;
        }

        public Setup<T> radius(double rad) {
            this.radius = rad;
            this.horizontal = rad;
            this.vertical = rad;
            return this;
        }

        public Setup<T> excludeEntity(T en) {
            this.excluded.add(en);
            return this;
        }

        public Setup<T> excludeCaster(boolean bool) {
            this.forceExcludeCaster = bool;
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SelectionType {
        TARGET{

            @Override
            public <T extends Entity> List<T> getEntities(Setup setup) {
                return null;
            }
        }
        ,
        RADIUS{

            @Override
            public <T extends Entity> List<T> getEntities(Setup setup) {
                double x = setup.pos.m_7096_();
                double y = setup.pos.m_7098_();
                double z = setup.pos.m_7094_();
                double hori = setup.horizontal;
                double verti = setup.vertical;
                AABB aabb = new AABB(x - hori, y - verti, z - hori, x + hori, y + verti, z + hori);
                if (setup.addTestParticles) {
                    Utilities.spawnParticlesForTesting(aabb, setup.world);
                }
                List entityList = setup.world.m_45976_(setup.entityType, aabb);
                return entityList;
            }
        }
        ,
        IN_FRONT{

            @Override
            public <T extends Entity> List<T> getEntities(Setup setup) {
                Entity entity = setup.caster;
                double distance = setup.distanceToSearch;
                double horizontal = setup.horizontal;
                double vertical = setup.vertical;
                double x = entity.m_20185_();
                double y = entity.m_20186_();
                double z = entity.m_20189_();
                Vec3 l = Utilities.getEndOfLook(entity, distance);
                double minX = Math.min(x, l.f_82479_);
                double minY = Math.min(y, l.f_82480_);
                double minZ = Math.min(z, l.f_82481_);
                double maxX = Math.max(x, l.f_82479_);
                double maxY = Math.max(y, l.f_82480_);
                double maxZ = Math.max(z, l.f_82481_);
                AABB aabb = new AABB(minX - horizontal, minY - vertical, minZ - horizontal, maxX + horizontal, maxY + vertical, maxZ + horizontal);
                if (setup.addTestParticles) {
                    Utilities.spawnParticlesForTesting(aabb, setup.world);
                }
                List entityList = entity.m_9236_().m_45976_(setup.entityType, aabb);
                entityList.removeIf(e -> e == entity);
                return entityList;
            }
        };


        public abstract <T extends Entity> List<T> getEntities(Setup var1);
    }
}

