/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas.rework.number_provider;

import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import java.util.Locale;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class NumberProvider {
    private Type type = Type.STAT_DATA;
    private String calc = "";

    public static NumberProvider specificNumber(int num) {
        NumberProvider p = new NumberProvider();
        p.calc = "" + num;
        p.type = Type.SPECIFIC_NUMBER;
        return p;
    }

    public static NumberProvider ofPercentOfStat(String stat) {
        NumberProvider p = new NumberProvider();
        p.calc = stat;
        p.type = Type.STAT_PERCENT;
        return p;
    }

    public static NumberProvider ofPercentOfDataNumber(String numId) {
        NumberProvider p = new NumberProvider();
        p.calc = numId;
        p.type = Type.NUMBER_PERCENT;
        return p;
    }

    public static NumberProvider ofStatData() {
        NumberProvider p = new NumberProvider();
        p.type = Type.STAT_DATA;
        return p;
    }

    public String getId() {
        return this.type.name().toLowerCase(Locale.ROOT);
    }

    public float getValue(EffectEvent event, LivingEntity source, StatData data) {
        float num = this.type.getValue(event, source, data, this.calc);
        return num;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        SPECIFIC_NUMBER{

            @Override
            public float getValue(EffectEvent event, LivingEntity source, StatData data, String calc) {
                int num = Integer.valueOf(calc);
                return num;
            }
        }
        ,
        STAT_DATA{

            @Override
            public float getValue(EffectEvent event, LivingEntity source, StatData data, String calc) {
                return data.getValue();
            }
        }
        ,
        STAT_PERCENT{

            @Override
            public float getValue(EffectEvent event, LivingEntity source, StatData data, String calc) {
                float val = Load.Unit((Entity)source).getUnit().getCalculatedStat(calc).getValue() * data.getValue() / 100.0f;
                return val;
            }
        }
        ,
        NUMBER_PERCENT{

            @Override
            public float getValue(EffectEvent event, LivingEntity source, StatData data, String calc) {
                float val = event.data.getNumber((String)calc).number * data.getValue() / 100.0f;
                return val;
            }
        };


        public abstract float getValue(EffectEvent var1, LivingEntity var2, StatData var3, String var4);
    }
}

