/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.tags;

import com.robertx22.mine_and_slash.tags.ModTag;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TagList<T extends ModTag> {
    public Set<String> tags;

    public TagList(List<T> tags) {
        this.tags = tags.stream().map(x -> x.GUID()).collect(Collectors.toSet());
    }

    public TagList(T ... tags) {
        this.tags = new HashSet<String>();
        for (T tag : tags) {
            this.tags.add(tag.GUID());
        }
    }

    public List<T> getTags(T clas) {
        return this.tags.stream().map(x -> clas.fromString((String)x)).collect(Collectors.toList());
    }

    public boolean contains(String tag) {
        return this.tags.contains(tag);
    }

    public boolean contains(T tag) {
        return this.tags.contains(tag.GUID());
    }

    public boolean containsAny(List<T> tag) {
        return tag.stream().anyMatch(x -> this.tags.contains(x.GUID()));
    }

    public void add(T t) {
        this.tags.add(t.GUID());
    }

    public void addAll(List<? extends T> list) {
        this.tags.addAll(list.stream().map(x -> x.GUID()).toList());
    }
}

