/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.stat_soul;

import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.level_ranges.LevelRange;
import com.robertx22.mine_and_slash.database.data.profession.items.CraftedSoulItem;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.SalvageBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.itemstack.CustomItemData;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.ExileStacklessData;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.stat_soul.SavedGearSoul;
import com.robertx22.mine_and_slash.tags.imp.SlotTag;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISettableLevelTier;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.temp.SkillItemTier;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class StatSoulData
implements ICommonDataItem<GearRarity>,
ISettableLevelTier {
    public int tier = 1;
    public String slot = "";
    public String rar = "";
    public SlotFamily fam = SlotFamily.NONE;
    public String uniq = "";
    public String force_tag = "";
    public boolean can_sal = true;
    public SavedGearSoul gear = null;

    public static boolean has(ItemStack stack) {
        CraftedSoulItem i;
        Item item;
        return StackSaving.STAT_SOULS.has(stack) || (item = stack.m_41720_()) instanceof CraftedSoulItem && (i = (CraftedSoulItem)item).getSoul(stack) != null;
    }

    public static StatSoulData ofFamily(GearRarity rar, SkillItemTier tier, SlotFamily fam) {
        StatSoulData data = new StatSoulData();
        data.tier = tier.tier;
        data.fam = fam;
        data.rar = rar.GUID();
        return data;
    }

    public boolean canBeOnAnySlot() {
        return this.slot.isEmpty();
    }

    public void setCanBeOnAnySlot() {
        this.slot = "";
    }

    public ItemStack toStack() {
        ItemStack stack = new ItemStack((ItemLike)SlashItems.STAT_SOUL.get());
        StackSaving.STAT_SOULS.saveTo(stack, (Object)this);
        if (!this.slot.isEmpty()) {
            stack.m_41784_().m_128405_("CustomModelData", ((GearSlot)ExileDB.GearSlots().get((String)this.slot)).model_num);
        }
        return stack;
    }

    public ItemStack insertAsUnidentifiedOn(ItemStack s, Player p) {
        ItemStack copy = s.m_41777_();
        if (this.gear != null) {
            this.gear.saveTo(copy);
            return copy;
        }
        ExileStacklessData e = this.createGearData(copy, p);
        ExileStack ex = ExileStack.of(copy);
        e.apply(ex);
        return ex.getStack();
    }

    public GearSlot getSlotFor(ItemStack stack) {
        GearSlot gearslot = (GearSlot)ExileDB.GearSlots().random();
        if (!this.slot.isEmpty()) {
            gearslot = (GearSlot)ExileDB.GearSlots().get(this.slot);
        }
        if (stack != null) {
            gearslot = GearSlot.getSlotOf(stack);
        }
        return gearslot;
    }

    public boolean forcesTag() {
        return !this.force_tag.isEmpty();
    }

    public boolean isArmor() {
        return this.fam == SlotFamily.Armor || !this.slot.isEmpty() && ((GearSlot)ExileDB.GearSlots().get((String)this.slot)).fam == SlotFamily.Armor;
    }

    public ExplainedResult canApplyTo(ItemStack stack) {
        GearSlot slot = GearSlot.getSlotOf(stack);
        if (slot == null) {
            return ExplainedResult.failure((Component)Chats.NOT_GEAR_OR_NOT_COMPAT.locName());
        }
        if (this.fam != SlotFamily.NONE) {
            if (slot.fam != this.fam) {
                return ExplainedResult.failure((Component)Chats.NOT_MATCHING_GEAR_FAMILY.locName());
            }
            return ExplainedResult.success();
        }
        if (this.canBeOnAnySlot()) {
            return ExplainedResult.success();
        }
        if (!this.slot.isEmpty()) {
            if (this.slot.equals(slot.GUID())) {
                return ExplainedResult.success();
            }
            return ExplainedResult.failure((Component)Chats.NOT_MATCHING_GEAR_SLOT.locName());
        }
        return ExplainedResult.silentlyFail();
    }

    public ExileStacklessData createGearData(@Nullable ItemStack stack, Player p) {
        UniqueGear uniq;
        List filted;
        int lvl = MathHelper.clamp(Load.Unit((Entity)p).getLevel(), LevelUtils.tierToLevel(this.tier).getMinLevel(), LevelUtils.tierToLevel(this.tier).getMaxLevel());
        GearBlueprint b = new GearBlueprint(LootInfo.ofLevel(lvl));
        b.level.set(lvl);
        b.rarity.set((GearRarity)ExileDB.GearRarities().get(this.rar));
        GearSlot gearslot = this.getSlotFor(stack);
        String slotid = gearslot.GUID();
        List possible = ExileDB.GearTypes().getFilterWrapped((Predicate<BaseGearType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createGearData$0(java.lang.String com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType ), (Lcom/robertx22/mine_and_slash/database/data/gear_types/bases/BaseGearType;)Z)((String)slotid)).list;
        if (this.forcesTag() && !(filted = possible.stream().filter(x -> x.tags.contains(this.force_tag)).collect(Collectors.toList())).isEmpty()) {
            possible = filted;
        }
        if (!possible.isEmpty()) {
            b.gearItemSlot.set((BaseGearType)RandomUtils.weightedRandom((Collection)possible));
        }
        if (!(uniq = (UniqueGear)ExileDB.UniqueGears().get(this.uniq)).isEmpty()) {
            b.uniquePart.set(uniq);
            b.rarity.set(uniq.getUniqueRarity());
            b.gearItemSlot.set(uniq.getBaseGear());
        }
        ExileStacklessData ex = b.createData();
        ex.getOrCreate(StackKeys.POTENTIAL).potential = (int)((double)ex.getOrCreate(StackKeys.POTENTIAL).potential * GameBalanceConfig.get().CRAFTED_GEAR_POTENTIAL_MULTI);
        ex.getOrCreate(StackKeys.CUSTOM).data.set(CustomItemData.KEYS.CRAFTED, true);
        ex.getOrCreate(StackKeys.CUSTOM).data.set(CustomItemData.KEYS.SALVAGING_DISABLED, !this.can_sal);
        return ex;
    }

    public ExplainedResult canInsertIntoStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return ExplainedResult.silentlyFail();
        }
        if (StackSaving.GEARS.has(stack)) {
            return ExplainedResult.failure((Component)Chats.ALREADY_HAS_SOUL.locName());
        }
        if (this.gear != null) {
            if (GearSlot.isItemOfThisSlot(this.gear.gear.GetBaseGearType().getGearSlot(), stack)) {
                return ExplainedResult.success();
            }
            return ExplainedResult.failure((Component)Chats.NOT_MATCHING_GEAR_SLOT.locName());
        }
        return this.canApplyTo(stack);
    }

    @Override
    public String getRarityId() {
        return this.rar;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
    }

    @Override
    public int getLevel() {
        return LevelUtils.levelToTier(this.tier);
    }

    @Override
    public ItemstackDataSaver<? extends ICommonDataItem> getStackSaver() {
        return StackSaving.STAT_SOULS;
    }

    public ExileTooltips getTooltip(ItemStack stack, boolean cangen) {
        ExileTooltips exileTooltips = new ExileTooltips().accept(new RarityBlock(this.getRarity())).accept(new UsageBlock(Collections.singletonList(Chats.INFUSES_STATS.locName().m_130940_(ChatFormatting.AQUA))));
        if (this.gear != null) {
            exileTooltips.accept(new AdditionalBlock((Component)Itemtips.CHECK_GEAR_STATS_IN_SOUL.locName().m_130940_(ChatFormatting.AQUA)));
            exileTooltips.accept(new OperationTipBlock().setAlt().setShift());
        } else {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            LevelRange levelRange = LevelUtils.tierToLevel(this.tier);
            tooltip.add(Itemtips.SOUL_GENERATE_GEAR_LEVEL_RANGE.locName(Component.m_237113_((String)("" + levelRange.getMinLevel())), Component.m_237113_((String)("" + levelRange.getMaxLevel()))).m_130940_(ChatFormatting.GOLD));
            if (new StatRangeInfo((ModRange)ModRange.hide()).hasAltDown) {
                // empty if block
            }
            if (!this.canBeOnAnySlot()) {
                if (this.fam != SlotFamily.NONE) {
                    tooltip.add(Itemtips.ITEM_TYPE.locName(Component.m_237113_((String)this.fam.name()).m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add(Itemtips.ITEM_TYPE.locName(((GearSlot)ExileDB.GearSlots().get(this.slot)).locName().m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (!Objects.equals(this.force_tag, "")) {
                SlotTag tag = new SlotTag(this.force_tag);
                tooltip.add(Itemtips.SOUL_LOCKED_TO_TYPE.locName(tag.locName()).m_130940_(ChatFormatting.GOLD));
            }
            exileTooltips.accept(new UsageBlock(tooltip));
            exileTooltips.accept(new OperationTipBlock().setShift());
        }
        exileTooltips.accept(WorksOnBlock.usableOn(WorksOnBlock.ItemType.SOULLESS_GEAR));
        exileTooltips.accept(new AdditionalBlock(Collections.singletonList(Chats.RIGHT_CLICK_TO_GEN_ITEM.locName().m_130940_(ChatFormatting.BLUE))).showWhen(() -> cangen)).accept(new SalvageBlock(this, ExileStack.of(stack)));
        return exileTooltips;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        StackSaving.STAT_SOULS.saveTo(stack, (Object)this);
    }

    @Override
    public List<ItemStack> getSalvageResult(ExileStack stack) {
        int amount = 1;
        return Arrays.asList(new ItemStack((ItemLike)RarityItems.RARITY_STONE.getOrDefault(this.getRarity().GUID(), RarityItems.RARITY_STONE.get("common")).get(), amount));
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        return ToggleAutoSalvageRarity.SalvageType.GEAR;
    }

    private static /* synthetic */ boolean lambda$createGearData$0(String slotid, BaseGearType x) {
        return x.gear_slot.equals(slotid);
    }
}

