/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.perks;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.perks.PerkStatus;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.perks.SchoolData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TalentsData
implements IStatCtx {
    HashMap<TalentTree.SchoolType, SchoolData> perks = new HashMap();

    public int getAllocatedPoints(TalentTree.SchoolType type) {
        return this.getSchool(type).getAllocatedPointsInSchool();
    }

    public SchoolData getSchool(TalentTree.SchoolType type) {
        return this.perks.computeIfAbsent(type, x -> new SchoolData());
    }

    public void allocate(Player player, TalentTree school, PointData point) {
        this.getSchool(school.getSchool_type()).allocate(point);
    }

    public void remove(TalentTree.SchoolType school, PointData point) {
        this.getSchool(school).unAllocate(point);
    }

    public boolean hasFreePoints(Player p, TalentTree.SchoolType type) {
        return type.getPointType().getFreePoints(p) > 0;
    }

    public boolean canAllocate(TalentTree school, PointData point, EntityData data, Player player) {
        Set<PointData> con;
        if (!this.hasFreePoints(player, school.getSchool_type())) {
            return false;
        }
        Perk perk = school.calcData.getPerk(point);
        if (!(perk.is_entry || (con = school.calcData.connections.get(point)) != null && con.stream().anyMatch(x -> this.getSchool(school.getSchool_type()).isAllocated((PointData)x)))) {
            return false;
        }
        return perk.one_kind == null || perk.one_kind.isEmpty() || !this.getAllAllocatedPerks(school.getSchool_type()).values().stream().anyMatch(x -> x.one_kind != null && x.one_kind.equals(perk.one_kind));
    }

    public boolean canRemove(Player p, TalentTree school, PointData point) {
        if (!this.getSchool(school.getSchool_type()).isAllocated(point)) {
            return false;
        }
        if (school.getSchool_type().getPointType().getResetPoints(p) < 1) {
            return false;
        }
        for (PointData con : school.calcData.connections.get(point)) {
            if (!this.getSchool(school.getSchool_type()).isAllocated(con)) continue;
            Perk perk = school.calcData.getPerk(con);
            if (perk.is_entry || this.hasPathToStart(school, con, point)) continue;
            return false;
        }
        return true;
    }

    private boolean hasPathToStart(TalentTree school, PointData check, PointData toRemove) {
        ArrayDeque openSet = new ArrayDeque();
        openSet.addAll(school.calcData.connections.get(check));
        HashSet<PointData> closedSet = new HashSet<PointData>();
        while (!openSet.isEmpty()) {
            PointData current = (PointData)openSet.poll();
            Perk perk = school.calcData.getPerk(current);
            if (current.equals(toRemove) || !this.getSchool(school.getSchool_type()).isAllocated(current)) continue;
            if (perk.is_entry) {
                return true;
            }
            if (!closedSet.add(current)) continue;
            openSet.addAll(school.calcData.connections.get(current));
        }
        return false;
    }

    public void clearAllTalents(TalentTree.SchoolType school) {
        this.perks.put(school, new SchoolData());
    }

    public HashMap<PointData, Perk> getAllAllocatedPerks(TalentTree.SchoolType type) {
        HashMap<PointData, Perk> perks = new HashMap<PointData, Perk>();
        ExileDB.TalentTrees().getFilterWrapped((Predicate<TalentTree>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getAllAllocatedPerks$3(com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree$SchoolType com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree ), (Lcom/robertx22/mine_and_slash/database/data/talent_tree/TalentTree;)Z)((TalentTree.SchoolType)type)).list.stream().findFirst().ifPresent(x -> {
            for (PointData p : this.getSchool(type).getAllocatedPoints((TalentTree)x)) {
                perks.put(p, x.calcData.getPerk(p));
            }
        });
        return perks;
    }

    public PerkStatus getStatus(Player player, TalentTree school, PointData point) {
        if (this.isAllocated(school, point)) {
            return PerkStatus.CONNECTED;
        }
        if (this.canAllocate(school, point, Load.Unit((Entity)player), player)) {
            return PerkStatus.POSSIBLE;
        }
        return PerkStatus.BLOCKED;
    }

    public Perk.Connection getConnection(TalentTree school, PointData one, PointData two) {
        if (this.isAllocated(school, one)) {
            if (this.isAllocated(school, two)) {
                return Perk.Connection.LINKED;
            }
            return Perk.Connection.POSSIBLE;
        }
        if (this.isAllocated(school, two)) {
            return Perk.Connection.POSSIBLE;
        }
        return Perk.Connection.BLOCKED;
    }

    public boolean isAllocated(TalentTree school, PointData point) {
        return this.getSchool(school.getSchool_type()).isAllocated(point);
    }

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<StatContext> ctx = new ArrayList<StatContext>();
        for (TalentTree.SchoolType type : TalentTree.SchoolType.values()) {
            HashMap<PointData, Perk> map = this.getAllAllocatedPerks(type);
            int lvl = Load.Unit((Entity)en).getLevel();
            ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
            map.forEach((key, value) -> value.stats.forEach(s -> stats.add(s.toExactStat(lvl))));
            ctx.add(new SimpleStatCtx(type.getCtxType(), stats));
        }
        return ctx;
    }

    private static /* synthetic */ boolean lambda$getAllAllocatedPerks$3(TalentTree.SchoolType type, TalentTree x) {
        return x.getSchool_type() == type;
    }
}

