/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips;

import com.robertx22.mine_and_slash.database.OptScaleExactStat;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;

public class TooltipStatInfo
implements ITooltipList {
    public Stat stat;
    public float firstValue;
    public ModType type;
    public StatRangeInfo tooltipInfo;
    public int percent = -99;
    public GearRarity affix_rarity = null;

    public TooltipStatInfo(ExactStatData data, int percent, StatRangeInfo info) {
        this.stat = data.getStat();
        this.firstValue = data.getFirstValue();
        this.type = data.getType();
        this.tooltipInfo = info;
        this.percent = percent;
    }

    public TooltipStatInfo(OptScaleExactStat data, StatRangeInfo info) {
        this.stat = data.getStat();
        this.firstValue = data.v1;
        this.type = data.getModType();
        this.tooltipInfo = info;
    }

    public boolean shouldShowDescriptions() {
        return this.tooltipInfo.shouldShowDescriptions();
    }

    public boolean useInDepthStats() {
        return this.tooltipInfo.useInDepthStats();
    }

    public void combine(TooltipStatInfo another) {
        this.firstValue += another.firstValue;
    }

    public boolean canBeCombined(TooltipStatInfo another) {
        return this.stat.GUID().equals(another.stat.GUID()) && this.type.equals((Object)another.type);
    }

    @Override
    public List<MutableComponent> GetTooltipString() {
        return this.stat.getTooltipList(new TooltipStatWithContext(this, null, null));
    }

    public static List<TooltipStatInfo> mergeDuplicates(List<TooltipStatInfo> duplicates) {
        ArrayList<TooltipStatInfo> list = new ArrayList<TooltipStatInfo>();
        for (TooltipStatInfo duplicate : duplicates) {
            Optional<TooltipStatInfo> found = list.stream().filter(x -> x.canBeCombined(duplicate)).findFirst();
            if (found.isPresent()) {
                found.get().combine(duplicate);
                continue;
            }
            list.add(duplicate);
        }
        return list;
    }
}

